/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr.transforms;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;

public class Xml2Rdf {
    static XMLInputFactory factory = XMLInputFactory.newInstance();
    private XMLStreamReader reader;
    private Model model;

    public Model triplify(Source xml) throws Exception {
        try {
            this.reader = factory.createXMLStreamReader(xml);
            this.model = ModelFactory.createDefaultModel();
            this.mapRoot();
        }
        catch (Exception e) {
            throw new Exception("cannot triplify xml source (see cause) ", e);
        }
        return this.model;
    }

    private void mapRoot() throws Exception {
        this.reader.nextTag();
        this.mapComplex(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private URI mapComplex(URI parentUri) throws Exception {
        QName name = this.reader.getName();
        URI uri = this.mint(name);
        if (parentUri == null) {
            parentUri = uri;
        }
        boolean complex = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            complex = true;
            this.emit(uri, this.reader.getAttributeName(i), this.reader.getAttributeValue(i));
        }
        block6: while (this.reader.hasNext()) {
            int next = this.reader.next();
            switch (next) {
                case 1: {
                    QName childName = this.reader.getName();
                    URI childURI = this.mapComplex(uri);
                    if (childURI != null) {
                        this.emit(uri, childName, childURI);
                    }
                    complex = true;
                    break;
                }
                case 4: {
                    if (this.reader.getText().trim().isEmpty()) break;
                    this.emit(complex ? uri : parentUri, name, this.reader.getText());
                    break;
                }
                case 2: {
                    break block6;
                }
            }
        }
        if (!complex) return null;
        URI uRI = uri;
        return uRI;
    }

    void emit(URI source, QName predicate, String literal) {
        Resource s = this.model.createResource(source.toString());
        Property p = this.model.createProperty("s:r/", predicate.getLocalPart());
        this.model.add(s, p, literal);
    }

    void emit(URI source, QName predicate, URI target) {
        Resource s = this.model.createResource(source.toString());
        Property p = this.model.createProperty("s:r/", predicate.getLocalPart());
        Resource o = this.model.createResource(target.toString());
        this.model.add(s, p, (RDFNode)o);
    }

    URI mint(QName name) throws Exception {
        return URI.create("s:r/" + name.getLocalPart() + "/" + UUID.randomUUID());
    }

    static {
        factory.setProperty("javax.xml.stream.isCoalescing", true);
    }
}

