/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr.transforms.mapping;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DCTerms;
import java.net.URI;
import org.fao.fi.comet.mapping.dsl.DataProviderDSL;
import org.fao.fi.comet.mapping.dsl.MappingDSL;
import org.fao.fi.comet.mapping.dsl.MappingDetailDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementIdentifierDSL;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingElement;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.sr.vocabularies.SKOS_CORE;
import org.virtualrepository.comet.CometAsset;
import org.virtualrepository.spi.Transform;

public class Rdf2CometMapping
implements Transform<CometAsset, Model, CodelistBean> {
    private static Logger log = LoggerFactory.getLogger(Rdf2CometMapping.class);

    public CodelistBean apply(CometAsset asset, Model m) throws Exception {
        log.info("transforming codelist " + asset.id() + " to comet mapping");
        MappingData mappingData = new MappingData();
        mappingData.linking(DataProviderDSL.provider((URI)URI.create("urn:provider:source"), (URI)URI.create("urn:source:type"), (URI)URI.create("urn:source:data:bar"))).to(DataProviderDSL.provider((URI)URI.create("urn:provider:target"), (URI)URI.create("urn:target:type"), (URI)URI.create("urn:target:data:bar")));
        ResIterator codes = m.listSubjectsWithProperty(SKOS_CORE.notation);
        while (codes.hasNext()) {
            Resource code_resource = (Resource)codes.next();
            mappingData.including(MappingDSL.map((MappingElement)MappingElementDSL.wrap((Object)"over-exploited").with(MappingElementIdentifierDSL.identifierFor((URI)URI.create("urn:id:33")))).to(MappingDetailDSL.target((MappingElement)MappingElementDSL.wrap((Object)"overexploited").with(MappingElementIdentifierDSL.identifierFor((URI)URI.create("urn:id:44"))))));
            ResIterator subjectEntities = m.listSubjectsWithProperty(DCTerms.subject, (RDFNode)code_resource);
            while (subjectEntities.hasNext()) {
                Resource subjectEntity = (Resource)subjectEntities.next();
                NodeIterator labels = m.listObjectsOfProperty(subjectEntity, SKOS_CORE.prefLabel);
                while (labels.hasNext()) {
                }
            }
            NodeIterator definitions = m.listObjectsOfProperty(code_resource, SKOS_CORE.definition);
            while (definitions.hasNext()) {
            }
        }
        return null;
    }

    public Class<Model> inputAPI() {
        return Model.class;
    }

    public Class<CodelistBean> outputAPI() {
        return CodelistBean.class;
    }
}

