/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr;

import java.net.URI;
import java.util.Properties;
import org.virtualrepository.Utils;

public class RepositoryConfiguration {
    private final Properties properties;

    public RepositoryConfiguration(Properties properties) {
        this.properties = properties;
        Utils.notNull((String)"configuration", (Object)properties);
        Utils.notNull((String)"staging_endpoint_update", (Object)properties.getProperty("staging_endpoint_update"));
        Utils.notNull((String)"staging_endpoint_data", (Object)properties.getProperty("staging_endpoint_data"));
        Utils.notNull((String)"staging_endpoint_query", (Object)properties.getProperty("staging_endpoint_query"));
        Utils.notNull((String)"public_endpoint_query", (Object)properties.getProperty("public_endpoint_query"));
        Utils.notNull((String)"public_endpoint_data", (Object)properties.getProperty("public_endpoint_data"));
        Utils.notNull((String)"query discovery query", (Object)properties.getProperty("query_all_sdmx_codelist"));
    }

    public URI staging_endpoint_update() {
        return URI.create(this.properties.getProperty("staging_endpoint_update"));
    }

    public URI staging_endpoint_data() {
        return URI.create(this.properties.getProperty("staging_endpoint_data"));
    }

    public URI staging_endpoint_query() {
        return URI.create(this.properties.getProperty("staging_endpoint_query"));
    }

    public URI public_endpoint_query() {
        return URI.create(this.properties.getProperty("public_endpoint_query"));
    }

    public URI public_endpoint_data() {
        return URI.create(this.properties.getProperty("public_endpoint_data"));
    }

    public String query_all_sdmx_codelist() {
        return this.properties.getProperty("query_all_sdmx_codelist");
    }

    public String query_get_codelist(String codelistUri) {
        String p = this.properties.getProperty("query_get_codelist");
        return p.replace("cl_uri", codelistUri);
    }
}

