/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.HTTPUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataAdmin {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataAdmin.class);

    public static void setPriv(HTTPUtils connection, String gnServiceURL, long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting privileges on md#" + metadataId));
        }
        Element adminRequest = GNMetadataAdmin.buildAdminRequest(metadataId, cfg);
        GNMetadataAdmin.gnAdminMetadata(connection, gnServiceURL, adminRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Set privileges for " + cfg.getPrivileges().size() + " groups on md#" + metadataId));
        }
    }

    private static Element buildAdminRequest(long metadataId, GNPrivConfiguration cfg) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(Long.toString(metadataId)));
        for (GNPrivConfiguration.Privileges grant : cfg.getPrivileges()) {
            Integer groupId = grant.getGroup();
            String ops = grant.getOps();
            for (char c : "012345".toCharArray()) {
                if (ops.indexOf(c) == -1) continue;
                String op = "" + '_' + groupId + '_' + c;
                request.addContent((Content)new Element(op).setText("on"));
            }
        }
        return request;
    }

    private static void gnAdminMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/eng/metadata.admin";
        GNMetadataAdmin.gnPut(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error setting metadata privileges in GeoNetwork");
        }
    }

    private static String gnPut(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

