/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn3;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GN3MetadataUpdate {
    private static final Logger LOGGER = Logger.getLogger(GN3MetadataUpdate.class);

    public static void update(HTTPUtils connection, String gnServiceURL, Long id, File inputFile) throws GNLibException, GNServerException {
        GN3MetadataUpdate.update(connection, gnServiceURL, id, inputFile, null);
    }

    public static void update(HTTPUtils connection, String gnServiceURL, Long id, File inputFile, String encoding) throws GNLibException, GNServerException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Using metadata file " + inputFile));
        }
        Element updateRequest = GN3MetadataUpdate.buildUpdateRequest(inputFile, id);
        LOGGER.debug((Object)("Updating metadata '" + id + "'"));
        GN3MetadataUpdate.gnUpdateMetadata(connection, gnServiceURL, updateRequest, encoding);
        LOGGER.info((Object)("Updated metadata '" + id + "'"));
    }

    private static Element buildUpdateRequest(File inputFile, Long id) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling request document");
        }
        Element metadataFromFile = GN3MetadataUpdate.parseFile(inputFile);
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        CDATA cdata = new CDATA(outputter.outputString(metadataFromFile));
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(String.valueOf(id)));
        request.addContent((Content)new Element("data").addContent((Content)cdata));
        return request;
    }

    private static void gnUpdateMetadata(HTTPUtils connection, String baseURL, Element gnRequest, String encoding) throws GNLibException, GNServerException {
        String serviceURL = baseURL + "/srv/eng/metadata.update.finish";
        connection.setIgnoreResponseContentOnSuccess(true);
        GN3MetadataUpdate.gnPost(connection, serviceURL, gnRequest, encoding);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error updating metadata in GeoNetwork (HTTP code " + connection.getLastHttpStatus() + ")");
        }
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest, String encoding) throws GNLibException, GNServerException {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s, encoding);
        return res;
    }

    private static Element parseFile(File file) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input file " + file));
            throw new GNLibException("Error parsing input file " + file, ex);
        }
    }
}

