/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class HTTPUtils {
    private static final Logger LOGGER = Logger.getLogger(HTTPUtils.class);
    private final String username;
    private final String pw;
    private HttpClient client = new HttpClient();
    private String xmlContentType = "text/xml";
    private int lastHttpStatus;
    private boolean ignoreResponseContentOnSuccess = false;

    public HTTPUtils() {
        this(null, null);
    }

    public HTTPUtils(String userName, String password) {
        this.username = userName;
        this.pw = password;
    }

    public void setXmlContentType(String xmlContentType) {
        this.xmlContentType = xmlContentType;
    }

    public int getLastHttpStatus() {
        return this.lastHttpStatus;
    }

    public boolean isIgnoreResponseContentOnSuccess() {
        return this.ignoreResponseContentOnSuccess;
    }

    public void setIgnoreResponseContentOnSuccess(boolean ignoreResponseContentOnSuccess) {
        this.ignoreResponseContentOnSuccess = ignoreResponseContentOnSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url) throws MalformedURLException {
        GetMethod httpMethod = null;
        try {
            HTTPUtils.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new GetMethod(url);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            if (this.lastHttpStatus == 200) {
                InputStream is = httpMethod.getResponseBodyAsStream();
                String response = IOUtils.toString((InputStream)is);
                if (response.trim().length() == 0) {
                    LOGGER.warn((Object)"ResponseBody is empty");
                    String string = null;
                    return string;
                }
                String string = response;
                return string;
            }
            LOGGER.info((Object)("(" + this.lastHttpStatus + ") " + HttpStatus.getStatusText((int)this.lastHttpStatus) + " -- " + url));
        }
        catch (ConnectException e) {
            LOGGER.info((Object)("Couldn't connect to [" + url + "]"));
        }
        catch (IOException e) {
            LOGGER.info((Object)("Error talking to [" + url + "]"), (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        return null;
    }

    public String putXml(String url, String content) {
        return this.put(url, content, this.xmlContentType);
    }

    public String put(String url, File file, String contentType) {
        return this.put(url, (RequestEntity)new FileRequestEntity(file, contentType));
    }

    public String put(String url, String content, String contentType) {
        try {
            return this.put(url, (RequestEntity)new StringRequestEntity(content, contentType, null));
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error((Object)("Cannot PUT " + url), (Throwable)ex);
            return null;
        }
    }

    public String put(String url, RequestEntity requestEntity) {
        return this.send((EntityEnclosingMethod)new PutMethod(url), url, requestEntity);
    }

    public String postXml(String url, String content) {
        return this.post(url, content, this.xmlContentType, null);
    }

    public String postXml(String url, String content, String encoding) {
        return this.post(url, content, this.xmlContentType, encoding);
    }

    public String postXml(String url, InputStream content) {
        return this.post(url, content, this.xmlContentType);
    }

    public String post(String url, File file, String contentType) {
        return this.post(url, (RequestEntity)new FileRequestEntity(file, contentType));
    }

    public String post(String url, String content, String contentType, String encoding) {
        try {
            return this.post(url, (RequestEntity)new StringRequestEntity(content, contentType, encoding));
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error((Object)("Cannot POST " + url), (Throwable)ex);
            return null;
        }
    }

    public String post(String url, String content, String contentType) {
        return this.post(url, content, contentType, null);
    }

    public String post(String url, InputStream content, String contentType) {
        return this.post(url, (RequestEntity)new InputStreamRequestEntity(content, contentType));
    }

    public String post(String url, RequestEntity requestEntity) {
        return this.send((EntityEnclosingMethod)new PostMethod(url), url, requestEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String send(EntityEnclosingMethod httpMethod, String url, RequestEntity requestEntity) {
        try {
            HTTPUtils.setAuth(this.client, url, this.username, this.pw);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            if (requestEntity != null) {
                httpMethod.setRequestEntity(requestEntity);
            }
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            switch (this.lastHttpStatus) {
                case 200: 
                case 201: 
                case 202: {
                    String response;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("HTTP " + httpMethod.getStatusText() + " <-- " + url));
                    }
                    if (this.ignoreResponseContentOnSuccess) {
                        String string = "";
                        return string;
                    }
                    String string = response = IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream());
                    return string;
                }
            }
            String badresponse = IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream());
            String message = HTTPUtils.getGeoNetworkErrorMessage(badresponse);
            LOGGER.warn((Object)("Bad response: " + this.lastHttpStatus + " " + httpMethod.getStatusText() + " -- " + httpMethod.getName() + " " + url + " : " + message));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("GeoNetwork response:\n" + badresponse));
            }
            String string = null;
            return string;
        }
        catch (ConnectException e) {
            LOGGER.info((Object)("Couldn't connect to [" + url + "]"));
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error talking to " + url + " : " + e.getLocalizedMessage()));
            String string = null;
            return string;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String url) {
        DeleteMethod httpMethod = null;
        try {
            HTTPUtils.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new DeleteMethod(url);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            String response = "";
            if (this.lastHttpStatus == 200) {
                InputStream is;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("(" + this.lastHttpStatus + ") " + httpMethod.getStatusText() + " -- " + url));
                }
                if (!this.ignoreResponseContentOnSuccess && (response = IOUtils.toString((InputStream)(is = httpMethod.getResponseBodyAsStream()))).trim().equals("") && LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"ResponseBody is empty (this may be not an error since we just performed a DELETE call)");
                }
                boolean bl = true;
                return bl;
            }
            LOGGER.info((Object)("(" + this.lastHttpStatus + ") " + httpMethod.getStatusText() + " -- " + url));
            LOGGER.info((Object)("Response: '" + response + "'"));
        }
        catch (ConnectException e) {
            LOGGER.info((Object)("Couldn't connect to [" + url + "]"));
        }
        catch (IOException e) {
            LOGGER.info((Object)("Error talking to [" + url + "]"), (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean httpPing(String url) {
        GetMethod httpMethod = null;
        try {
            HTTPUtils.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new GetMethod(url);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            if (this.lastHttpStatus != 200) {
                LOGGER.warn((Object)("PING failed at '" + url + "': (" + this.lastHttpStatus + ") " + httpMethod.getStatusText()));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ConnectException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    public boolean exists(String url) {
        GetMethod httpMethod = null;
        try {
            HTTPUtils.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new GetMethod(url);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            switch (this.lastHttpStatus) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                throw new RuntimeException("Unhandled response status at '" + url + "': (" + this.lastHttpStatus + ") " + httpMethod.getStatusText());
            }
            catch (ConnectException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private static void setAuth(HttpClient client, String url, String username, String pw) throws MalformedURLException {
        URL u = new URL(url);
        if (username != null && pw != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, pw);
            client.getState().setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)defaultcreds);
            client.getParams().setAuthenticationPreemptive(true);
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Not setting credentials to access to " + url));
        }
    }

    protected static String getGeoNetworkErrorMessage(String msg) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document error = builder.build((Reader)new StringReader(msg));
            return error.getRootElement().getChildText("message");
        }
        catch (Exception ex) {
            return "-";
        }
    }

    protected static String getGeoNetworkErrorMessage(InputStream msg) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document error = builder.build(msg);
            return error.getRootElement().getChildText("message");
        }
        catch (Exception ex) {
            return "-";
        }
    }
}

