/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork;

import it.geosolutions.geonetwork.GNAbstractClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.GNInfo;
import it.geosolutions.geonetwork.op.GNMetadataAdmin;
import it.geosolutions.geonetwork.op.GNMetadataDelete;
import it.geosolutions.geonetwork.op.GNMetadataGet;
import it.geosolutions.geonetwork.op.GNMetadataGetInfo;
import it.geosolutions.geonetwork.op.GNMetadataGetVersion;
import it.geosolutions.geonetwork.op.GNMetadataInsert;
import it.geosolutions.geonetwork.op.GNMetadataSearch;
import it.geosolutions.geonetwork.op.GNMetadataUpdate;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataGetInfo;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class GN2Client
extends GNAbstractClient {
    private static final Logger LOGGER = Logger.getLogger(GN2Client.class);

    public GN2Client(String serviceURL) {
        super(serviceURL);
        LOGGER.info((Object)"A Geonetwork2 client successfully instantiated!");
    }

    public GN2Client(String serviceURL, String username, String password) {
        super(serviceURL, username, password);
        LOGGER.info((Object)"A Geonetwork2 client successfully instantiated!");
    }

    @Override
    public boolean ping() {
        return GNInfo.ping(this.connection, this.gnServiceURL);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertMetadata(this.connection, this.gnServiceURL, metadataFile, cfg);
    }

    @Override
    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertRequest(this.connection, this.gnServiceURL, requestFile);
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        GNMetadataAdmin.setPriv(this.connection, this.gnServiceURL, metadataId, cfg);
    }

    @Override
    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, searchRequest);
    }

    @Override
    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, fileRequest);
    }

    @Override
    public Element get(Long id) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, id);
    }

    @Override
    public Element get(String uuid) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, uuid);
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        GNMetadataDelete.delete(this.connection, this.gnServiceURL, id);
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        String version = GNMetadataGetVersion.get(this.connection, this.gnServiceURL, id);
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, version, metadataFile);
    }

    @Override
    public void updateMetadata(long id, File metadataFile, String encoding) throws GNLibException, GNServerException {
        String version = GNMetadataGetVersion.get(this.connection, this.gnServiceURL, id);
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, version, metadataFile, encoding);
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(Long id) throws GNLibException, GNServerException {
        throw new UnsupportedOperationException("Operation supported only for GeoNetwork 3");
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(String uuid) throws GNLibException, GNServerException {
        throw new UnsupportedOperationException("Operation supported only for GeoNetwork 3");
    }

    public void updateMetadata(long id, int version, File metadataFile) throws GNLibException, GNServerException {
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, Integer.toString(version), metadataFile);
    }

    public void updateMetadata(long id, int version, File metadataFile, String encoding) throws GNLibException, GNServerException {
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, Integer.toString(version), metadataFile, encoding);
    }

    @Deprecated
    public GNMetadataGetInfo.MetadataInfo getInfo(Long id, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.connection, this.gnServiceURL, id, forUpdate);
    }

    @Deprecated
    public GNMetadataGetInfo.MetadataInfo getInfo(String uuid, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.connection, this.gnServiceURL, uuid, forUpdate);
    }

    @Deprecated
    public boolean login(String username, String password) {
        LOGGER.error((Object)"Login operation is no longer supported. Please use authenticated constructor");
        return false;
    }
}

