/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.io;

import it.geosolutions.geonetwork.GN2Client;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GN2MetadataPublisher {
    private static final Logger LOGGER = Logger.getLogger(GN2MetadataPublisher.class);

    public static void main(String[] args) throws IOException, GNLibException, GNServerException {
        if (args.length < 4) {
            throw new IOException("Please provide input parameters (gnServiceURL, gnUsername, gnPassword, mdFile).");
        }
        String gnServiceURL = args[0];
        String gnUsername = args[1];
        String gnPassword = args[2];
        String mdFile = args[3];
        LOGGER.info((Object)("Trying to ingest metadata " + mdFile + " to " + gnServiceURL + "[" + gnUsername + "]"));
        GN2Client client = new GN2Client(gnServiceURL);
        boolean logged = client.login(gnUsername, gnPassword);
        if (!logged) {
            throw new RuntimeException("Could not log in");
        }
        GNInsertConfiguration cfg = new GNInsertConfiguration();
        cfg.setCategory("datasets");
        cfg.setGroup("1");
        cfg.setStyleSheet("_none_");
        cfg.setValidate(Boolean.TRUE);
        File file = new File(mdFile);
        long id = client.insertMetadata(cfg, file);
        LOGGER.info((Object)("Metadata created with id " + id));
    }
}

