/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataDelete {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataDelete.class);

    public static void delete(HTTPUtils connection, String gnServiceURL, long metadataId) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting md#" + metadataId));
        }
        Element idRequest = GNMetadataDelete.buildIdRequest(metadataId);
        GNMetadataDelete.gnDeleteMetadata(connection, gnServiceURL, idRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Deleted md#" + metadataId));
        }
    }

    private static Element buildIdRequest(long metadataId) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling id request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(Long.toString(metadataId)));
        return request;
    }

    private static void gnDeleteMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/eng/xml.metadata.delete";
        GNMetadataDelete.gnPost(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error deleting metadata in GeoNetwork");
        }
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

