/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn3;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class GN3MetadataGetInfo {
    private static final Logger LOGGER = Logger.getLogger(GN3MetadataGetInfo.class);

    public static MetadataInfo get(HTTPUtils connection, String gnServiceURL, Long id) throws GNLibException, GNServerException {
        return GN3MetadataGetInfo.getAux(connection, gnServiceURL, "_id=" + id);
    }

    public static MetadataInfo get(HTTPUtils connection, String gnServiceURL, String uuid) throws GNLibException, GNServerException {
        return GN3MetadataGetInfo.getAux(connection, gnServiceURL, "uuid=" + uuid);
    }

    protected static MetadataInfo getAux(HTTPUtils connection, String gnServiceURL, String queryId) throws GNLibException, GNServerException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieve metadata info for " + queryId));
            }
            String serviceName = "q";
            String serviceURL = gnServiceURL + "/srv/eng/" + serviceName + "?" + queryId;
            connection.setIgnoreResponseContentOnSuccess(false);
            String response = connection.get(serviceURL);
            if (LOGGER.isDebugEnabled()) {
                if (response != null) {
                    LOGGER.debug((Object)("Response is " + response.length() + " chars long"));
                } else {
                    LOGGER.debug((Object)"Response is null");
                }
            }
            if (connection.getLastHttpStatus() != 200) {
                throw new GNServerException("Error retrieving data in GeoNetwork", connection.getLastHttpStatus());
            }
            MetadataInfo ret = GN3MetadataGetInfo.parseMetadataInfo(response);
            return ret;
        }
        catch (MalformedURLException ex) {
            throw new GNLibException("Bad URL", ex);
        }
    }

    private static MetadataInfo parseMetadataInfo(String response) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Element root = builder.build((Reader)new StringReader(response)).detachRootElement();
            Namespace NS_GEONET = Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork");
            Element metadata = root.getChild("metadata");
            if (metadata == null) {
                return null;
            }
            Element geonetinfo = metadata.getChild("info", NS_GEONET);
            if (geonetinfo == null) {
                return null;
            }
            String id = geonetinfo.getChildText("id");
            String uuid = geonetinfo.getChildText("uuid");
            MetadataInfo info = new MetadataInfo();
            info.id = Long.parseLong(id);
            info.uuid = uuid;
            info.createDate = geonetinfo.getChildText("createDate");
            info.changeDate = geonetinfo.getChildText("changeDate");
            info.source = geonetinfo.getChildText("source");
            info.category = geonetinfo.getChildText("category");
            info.schema = geonetinfo.getChildText("schema");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("metadata info: '" + info.toString()));
            }
            return info;
        }
        catch (JDOMException ex) {
            LOGGER.error((Object)("Error parsing GN response: " + response));
            throw new GNLibException("Error parsing GN response: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new GNLibException("Error while outputting", ex);
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)("Error parsing number in GN response: " + response));
            throw new GNLibException("Error parsing number in GN response: " + ex.getMessage(), ex);
        }
    }

    public static class MetadataInfo {
        long id;
        String uuid;
        String schema;
        String createDate;
        String changeDate;
        String source;
        String category;

        public long getId() {
            return this.id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public String getChangeDate() {
            return this.changeDate;
        }

        public String getSource() {
            return this.source;
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return "MetadataInfo[id=" + this.id + ", uuid=" + this.uuid + ", schema=" + this.schema + ", createDate=" + this.createDate + ", changeDate=" + this.changeDate + ", source=" + this.source + ", category=" + this.category + ']';
        }
    }
}

