/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork;

import it.geosolutions.geonetwork.GNAbstractClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.gn2x.GNInfo;
import it.geosolutions.geonetwork.op.gn2x.GNLogin;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataAdmin;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataDelete;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataGet;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataGetVersion;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataInsert;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataSearch;
import it.geosolutions.geonetwork.op.gn2x.GNMetadataUpdate;
import it.geosolutions.geonetwork.op.gn2x.custom.GNMetadataGetInfo;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataGetInfo;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Element;

abstract class GN2xClient
extends GNAbstractClient {
    private static final Logger LOGGER = Logger.getLogger(GN2xClient.class);
    private boolean loggedin = false;
    private final String username;
    private final String password;
    protected final GNVersion version;

    public GN2xClient(GNVersion v, String serviceURL) {
        this(v, serviceURL, null, null);
    }

    public GN2xClient(GNVersion v, String serviceURL, String username, String password) {
        super(serviceURL);
        this.username = username;
        this.password = password;
        this.version = v;
        LOGGER.info((Object)("A Geonetwork " + (Object)((Object)v) + " client successfully instantiated!"));
    }

    @Override
    public HTTPUtils getConnection() throws GNLibException {
        if (!this.loggedin && this.username != null && this.password != null) {
            LOGGER.info((Object)("Logging into GeoNetwork with user '" + this.username + "'"));
            if (GNLogin.get(this.version).login(this.connection, this.gnServiceURL, this.username, this.password)) {
                this.loggedin = true;
            } else {
                throw new GNLibException("Authentication error");
            }
        }
        return this.connection;
    }

    @Override
    public boolean ping() {
        try {
            return GNInfo.get(this.version).ping(this.getConnection(), this.gnServiceURL);
        }
        catch (GNLibException ex) {
            LOGGER.warn((Object)("Error in ping: " + ex.getMessage()));
            return false;
        }
    }

    @Override
    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.get(this.version).insertMetadata(this.getConnection(), this.gnServiceURL, metadataFile, cfg);
    }

    @Override
    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.get(this.version).insertRequest(this.getConnection(), this.gnServiceURL, requestFile);
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        GNMetadataAdmin.get(this.version).setPriv(this.getConnection(), this.gnServiceURL, metadataId, cfg);
    }

    @Override
    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.get(this.version).search(this.getConnection(), this.gnServiceURL, searchRequest);
    }

    @Override
    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.get(this.version).search(this.getConnection(), this.gnServiceURL, fileRequest);
    }

    @Override
    public Element get(Long id) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.version).get(this.getConnection(), this.gnServiceURL, id);
    }

    @Override
    public Element get(String uuid) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.version).get(this.getConnection(), this.gnServiceURL, uuid);
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        GNMetadataDelete.get(this.version).delete(this.getConnection(), this.gnServiceURL, id);
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        String mdversion = GNMetadataGetVersion.get(this.version).get(this.connection, this.gnServiceURL, id);
        GNMetadataUpdate.get(this.version).update(this.getConnection(), this.gnServiceURL, id, mdversion, metadataFile);
    }

    @Override
    public void updateMetadata(long id, File metadataFile, String encoding) throws GNLibException, GNServerException {
        String mdversion = GNMetadataGetVersion.get(this.version).get(this.connection, this.gnServiceURL, id);
        GNMetadataUpdate.get(this.version).update(this.getConnection(), this.gnServiceURL, id, mdversion, metadataFile, encoding);
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(Long id) throws GNLibException, GNServerException {
        throw new UnsupportedOperationException("Operation supported only by GeoNetwork 3");
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(String uuid) throws GNLibException, GNServerException {
        throw new UnsupportedOperationException("Operation supported only by GeoNetwork 3");
    }

    public void updateMetadata(long id, int mdversion, File metadataFile) throws GNLibException, GNServerException {
        GNMetadataUpdate.get(this.version).update(this.getConnection(), this.gnServiceURL, id, Integer.toString(mdversion), metadataFile);
    }

    public void updateMetadata(long id, int mdversion, File metadataFile, String encoding) throws GNLibException, GNServerException {
        GNMetadataUpdate.get(this.version).update(this.getConnection(), this.gnServiceURL, id, Integer.toString(mdversion), metadataFile, encoding);
    }

    @Deprecated
    public GNMetadataGetInfo.MetadataInfo getInfo(Long id, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.getConnection(), this.gnServiceURL, id, forUpdate);
    }

    @Deprecated
    public GNMetadataGetInfo.MetadataInfo getInfo(String uuid, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.getConnection(), this.gnServiceURL, uuid, forUpdate);
    }
}

