/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork;

import it.geosolutions.geonetwork.GNAbstractClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.gn210.GNInfo;
import it.geosolutions.geonetwork.op.gn210.GNMetadataDelete;
import it.geosolutions.geonetwork.op.gn210.GNMetadataGet;
import it.geosolutions.geonetwork.op.gn210.GNMetadataInsert;
import it.geosolutions.geonetwork.op.gn210.GNMetadataSearch;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataAdmin;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataGetInfo;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataUpdate;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class GN3Client
extends GNAbstractClient {
    private static final Logger LOGGER = Logger.getLogger(GN3Client.class);

    public GN3Client(String serviceURL) {
        super(serviceURL);
        LOGGER.info((Object)"A Geonetwork3 client successfully instantiated!");
    }

    public GN3Client(String serviceURL, String username, String password) {
        super(serviceURL, username, password);
        LOGGER.info((Object)"A Geonetwork3 client successfully instantiated!");
    }

    @Override
    public boolean ping() {
        return GNInfo.ping(this.connection, this.gnServiceURL);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertMetadata(this.connection, this.gnServiceURL, metadataFile, cfg);
    }

    @Override
    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertRequest(this.connection, this.gnServiceURL, requestFile);
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        GN3MetadataAdmin.setPriv(this.connection, this.gnServiceURL, metadataId, cfg);
    }

    @Override
    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, searchRequest);
    }

    @Override
    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, fileRequest);
    }

    @Override
    public Element get(Long id) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, id);
    }

    @Override
    public Element get(String uuid) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, uuid);
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        GNMetadataDelete.delete(this.connection, this.gnServiceURL, id);
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        GN3MetadataUpdate.update(this.connection, this.gnServiceURL, id, metadataFile);
    }

    @Override
    public void updateMetadata(long id, File metadataFile, String encoding) throws GNLibException, GNServerException {
        GN3MetadataUpdate.update(this.connection, this.gnServiceURL, id, metadataFile, encoding);
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(Long id) throws GNLibException, GNServerException {
        return GN3MetadataGetInfo.get(this.connection, this.gnServiceURL, id);
    }

    @Override
    public GN3MetadataGetInfo.MetadataInfo getInfo(String uuid) throws GNLibException, GNServerException {
        return GN3MetadataGetInfo.get(this.connection, this.gnServiceURL, uuid);
    }
}

