/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn210;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataGet {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataGet.class);

    public static Element get(HTTPUtils connection, String gnServiceURL, Long id) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Retrieve metadata #" + id));
        }
        return GNMetadataGet.get(connection, gnServiceURL, id, null);
    }

    public static Element get(HTTPUtils connection, String gnServiceURL, String uuid) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Retrieve metadata " + uuid));
        }
        return GNMetadataGet.get(connection, gnServiceURL, null, uuid);
    }

    protected static Element get(HTTPUtils connection, String gnServiceURL, Long id, String uuid) throws GNLibException, GNServerException {
        Element request = GNMetadataGet.buildRequest(id, uuid);
        String response = GNMetadataGet.gnGetMetadata(connection, gnServiceURL, request);
        Element eResponse = GNMetadataGet.parse(response);
        return eResponse;
    }

    protected static Element buildRequest(Long id, String uuid) {
        Element request = new Element("request");
        if (id != null) {
            request.addContent((Content)new Element("id").setText(String.valueOf(id)));
        } else if (uuid != null) {
            request.addContent((Content)new Element("uuid").setText(uuid));
        }
        return request;
    }

    private static String gnGetMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/eng/xml.metadata.get";
        String resp = GNMetadataGet.gnPost(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error retrieving metadata in GeoNetwork");
        }
        return resp;
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String xmlReq = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        return connection.postXml(serviceURL, xmlReq);
    }

    private static Element parse(String s) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build((Reader)new StringReader(s)).detachRootElement();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error parsing GN response: " + s));
            throw new GNLibException("Error parsing GN response: " + ex.getMessage(), ex);
        }
    }
}

