/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn210;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataUpdate {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataUpdate.class);

    public static void update(HTTPUtils connection, String gnServiceURL, Long id, String version, File inputFile) throws GNLibException, GNServerException {
        GNMetadataUpdate.update(connection, gnServiceURL, id, version, inputFile, null);
    }

    public static void update(HTTPUtils connection, String gnServiceURL, Long id, String version, File inputFile, String encoding) throws GNLibException, GNServerException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Using metadata file " + inputFile));
        }
        Element updateRequest = GNMetadataUpdate.buildUpdateRequest(inputFile, id, version);
        LOGGER.debug((Object)("Updating metadata " + id + " version " + version));
        GNMetadataUpdate.gnUpdateMetadata(connection, gnServiceURL, updateRequest, encoding);
        LOGGER.info((Object)("Updated metadata " + id + " version " + version));
    }

    private static Element buildUpdateRequest(File inputFile, Long id, String version) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling request document");
        }
        Element metadataFromFile = GNMetadataUpdate.parseFile(inputFile);
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        CDATA cdata = new CDATA(outputter.outputString(metadataFromFile));
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(String.valueOf(id)));
        request.addContent((Content)new Element("version").setText(version));
        request.addContent((Content)new Element("data").addContent((Content)cdata));
        return request;
    }

    private static void gnUpdateMetadata(HTTPUtils connection, String baseURL, Element gnRequest, String encoding) throws GNLibException, GNServerException {
        String serviceURL = baseURL + "/srv/eng/metadata.update.finish";
        connection.setIgnoreResponseContentOnSuccess(true);
        String res = GNMetadataUpdate.gnPost(connection, serviceURL, gnRequest, encoding);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error updating metadata in GeoNetwork (HTTP code " + connection.getLastHttpStatus() + ")");
        }
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest, String encoding) throws GNLibException, GNServerException {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s, encoding);
        return res;
    }

    private static Element parseFile(File file) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input file " + file));
            throw new GNLibException("Error parsing input file " + file, ex);
        }
    }

    private static Element parse(String s) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            s = s.trim();
            Document doc = builder.build((Reader)new StringReader(s));
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input string: >>>" + s + "<<<"));
            throw new GNLibException("Error parsing input string", ex);
        }
    }
}

