/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn210.custom;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class GNMetadataGetStatus {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataGetStatus.class);

    public static MetadataInfo get(HTTPUtils connection, String gnServiceURL, Long id, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetStatus.getAux(connection, gnServiceURL, "id=" + id, forUpdate);
    }

    public static MetadataInfo get(HTTPUtils connection, String gnServiceURL, String uuid, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetStatus.getAux(connection, gnServiceURL, "uuid=" + uuid, forUpdate);
    }

    protected static MetadataInfo getAux(HTTPUtils connection, String gnServiceURL, String queryId, boolean forUpdate) throws GNLibException, GNServerException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieve metadata info for " + queryId));
            }
            String serviceName = forUpdate ? "getForUpdate" : "get";
            String serviceURL = gnServiceURL + "/srv/eng/xml.metadata.info." + serviceName + "?" + queryId;
            connection.setIgnoreResponseContentOnSuccess(false);
            String response = connection.get(serviceURL);
            if (LOGGER.isDebugEnabled()) {
                if (response != null) {
                    LOGGER.debug((Object)("Response is " + response.length() + " chars long"));
                } else {
                    LOGGER.debug((Object)"Response is null");
                }
            }
            if (connection.getLastHttpStatus() != 200) {
                throw new GNServerException("Error retrieving data in GeoNetwork", connection.getLastHttpStatus());
            }
            MetadataInfo ret = GNMetadataGetStatus.parseMetadataInfo(response);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Metadata " + queryId + " has info " + ret));
            }
            return ret;
        }
        catch (MalformedURLException ex) {
            throw new GNLibException("Bad URL", ex);
        }
    }

    private static MetadataInfo parseMetadataInfo(String response) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Element root = builder.build((Reader)new StringReader(response)).detachRootElement();
            String id = root.getChildText("id");
            String uuid = root.getChildText("uuid");
            String sver = root.getChildText("version");
            MetadataInfo info = new MetadataInfo();
            info.id = Long.parseLong(id);
            info.uuid = uuid;
            if (sver != null && !sver.isEmpty()) {
                info.version = Integer.parseInt(sver);
            }
            return info;
        }
        catch (JDOMException ex) {
            LOGGER.error((Object)("Error parsing GN response: " + response));
            throw new GNLibException("Error parsing GN response: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new GNLibException("Error while outputting", ex);
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)("Error parsing number in GN response: " + response));
            throw new GNLibException("Error parsing number in GN response: " + ex.getMessage(), ex);
        }
    }

    public static class MetadataInfo {
        long id;
        String uuid;
        Integer version;

        public long getId() {
            return this.id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Integer getVersion() {
            return this.version;
        }

        public String toString() {
            return "MetadataInfo[id=" + this.id + ", uuid=" + this.uuid + (this.version != null ? ", version=" + this.version : "") + ']';
        }
    }
}

