/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;

public class GNInfo {
    private static final Logger LOGGER = Logger.getLogger(GNInfo.class);
    private final GNVersion version;
    public static final GNInfo V26 = new GNInfo(GNVersion.V26);
    public static final GNInfo V28 = new GNInfo(GNVersion.V28);

    public static GNInfo get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNInfo(GNVersion v) {
        this.version = v;
    }

    public boolean ping(HTTPUtils connection, String serviceURL) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"PING");
        }
        connection.setIgnoreResponseContentOnSuccess(true);
        String url = serviceURL + "/srv/" + this.getLang() + "/test.csw";
        try {
            connection.get(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)ex.getMessage());
            return false;
        }
        if (connection.getLastHttpStatus() != 200) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"PING failed");
            }
            return false;
        }
        return true;
    }
}

