/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNLogin {
    private static final Logger LOGGER = Logger.getLogger(GNLogin.class);
    private final GNVersion version;
    public static final GNLogin V26 = new GNLogin(GNVersion.V26);
    public static final GNLogin V28 = new GNLogin(GNVersion.V28);

    public static GNLogin get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNLogin(GNVersion v) {
        this.version = v;
    }

    public boolean login(HTTPUtils connection, String serviceURL, String username, String password) {
        Element request = new Element("request");
        request.addContent((Content)new Element("username").setText(username));
        request.addContent((Content)new Element("password").setText(password));
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String xml = outputter.outputString(request);
        String loginURL = serviceURL + "/srv/" + this.getLang() + "/xml.user.login";
        String out = connection.postXml(loginURL, xml);
        return connection.getLastHttpStatus() == 200;
    }
}

