/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataAdmin {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataAdmin.class);
    private final GNVersion version;
    public static final GNMetadataAdmin V26 = new GNMetadataAdmin(GNVersion.V26);
    public static final GNMetadataAdmin V28 = new GNMetadataAdmin(GNVersion.V28);

    public static GNMetadataAdmin get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNMetadataAdmin(GNVersion v) {
        this.version = v;
    }

    public void setPriv(HTTPUtils connection, String gnServiceURL, long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting privileges on md#" + metadataId));
        }
        Element adminRequest = this.buildAdminRequest(metadataId, cfg);
        this.gnAdminMetadata(connection, gnServiceURL, adminRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Set privileges for " + cfg.getPrivileges().size() + " groups on md#" + metadataId));
        }
    }

    private Element buildAdminRequest(long metadataId, GNPrivConfiguration cfg) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(Long.toString(metadataId)));
        for (GNPrivConfiguration.Privileges grant : cfg.getPrivileges()) {
            Integer groupId = grant.getGroup();
            String ops = grant.getOps();
            for (char c : "012345".toCharArray()) {
                if (ops.indexOf(c) == -1) continue;
                String op = "" + '_' + groupId + '_' + c;
                request.addContent((Content)new Element(op).setText("on"));
            }
        }
        return request;
    }

    private void gnAdminMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/" + this.getLang() + "/metadata.admin";
        this.gnPut(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error setting metadata privileges in GeoNetwork");
        }
    }

    private String gnPut(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

