/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataDelete {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataDelete.class);
    private final GNVersion version;
    public static final GNMetadataDelete V26 = new GNMetadataDelete(GNVersion.V26);
    public static final GNMetadataDelete V28 = new GNMetadataDelete(GNVersion.V28);

    public static GNMetadataDelete get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNMetadataDelete(GNVersion v) {
        this.version = v;
    }

    public void delete(HTTPUtils connection, String gnServiceURL, long metadataId) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting md#" + metadataId));
        }
        Element idRequest = GNMetadataDelete.buildIdRequest(metadataId);
        this.gnDeleteMetadata(connection, gnServiceURL, idRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Deleted md#" + metadataId));
        }
    }

    private static Element buildIdRequest(long metadataId) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling id request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(Long.toString(metadataId)));
        return request;
    }

    private void gnDeleteMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/" + this.getLang() + "/xml.metadata.delete";
        GNMetadataDelete.gnPost(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error deleting metadata in GeoNetwork");
        }
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

