/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataGetVersion {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataGetVersion.class);
    private final GNVersion version;
    public static final GNMetadataGetVersion V26 = new GNMetadataGetVersion(GNVersion.V26);
    public static final GNMetadataGetVersion V28 = new GNMetadataGetVersion(GNVersion.V28);
    public static final Namespace NS_GEONET = Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork");
    public static final Namespace NS_GMD = Namespace.getNamespace((String)"gmd", (String)"http://www.isotc211.org/2005/gmd");

    public static GNMetadataGetVersion get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNMetadataGetVersion(GNVersion v) {
        this.version = v;
    }

    public String get(HTTPUtils connection, String gnServiceURL, Long id) throws GNLibException, GNServerException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieve metadata #" + id));
            }
            String serviceURL = gnServiceURL + "/srv/" + this.getLang() + "/metadata.edit!?id=" + id;
            connection.setIgnoreResponseContentOnSuccess(false);
            String response = connection.get(serviceURL);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Response is " + response.length() + " chars long"));
            }
            if (connection.getLastHttpStatus() != 200) {
                throw new GNServerException("Error retrieving metadata in GeoNetwork");
            }
            String version = GNMetadataGetVersion.parseVersion(response);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Metadata " + id + " has version " + version));
            }
            return version;
        }
        catch (MalformedURLException ex) {
            throw new GNLibException("Bad URL", ex);
        }
    }

    private static String parseVersion(String s) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Element root = builder.build((Reader)new StringReader(s)).detachRootElement();
            Element metadata = root.getChild("MD_Metadata", NS_GMD);
            if (metadata == null) {
                LOGGER.error((Object)"Could not find MD_Metadata child");
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                outputter.output(root, (OutputStream)System.out);
                throw new GNLibException("Could not find MD_Metadata child");
            }
            Element geonetInfo = metadata.getChild("info", NS_GEONET);
            if (geonetInfo == null) {
                LOGGER.error((Object)"Could not find geonet:info child");
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                outputter.output(root, (OutputStream)System.out);
                throw new GNLibException("Could not find geonet:info child");
            }
            String version = geonetInfo.getChildText("version");
            return version;
        }
        catch (JDOMException ex) {
            LOGGER.error((Object)("Error parsing GN response: " + s));
            throw new GNLibException("Error parsing GN response: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new GNLibException("Error while outputting", ex);
        }
    }
}

