/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.op.gn2x;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.GNVersion;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataSearch {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataSearch.class);
    private final GNVersion version;
    public static final GNMetadataSearch V26 = new GNMetadataSearch(GNVersion.V26);
    public static final GNMetadataSearch V28 = new GNMetadataSearch(GNVersion.V28);

    public static GNMetadataSearch get(GNVersion v) {
        switch (v) {
            case V26: {
                return V26;
            }
            case V28: {
                return V28;
            }
        }
        throw new IllegalStateException("Bad version requested " + (Object)((Object)v));
    }

    private String getLang() {
        return this.version == GNVersion.V26 ? "en" : "eng";
    }

    private GNMetadataSearch(GNVersion v) {
        this.version = v;
    }

    public GNSearchResponse search(HTTPUtils connection, String gnServiceURL, GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Search metadata");
        }
        Element request = searchRequest.toElement();
        return this.search(connection, gnServiceURL, request);
    }

    public GNSearchResponse search(HTTPUtils connection, String gnServiceURL, File fileRequest) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search metadata " + fileRequest));
        }
        Element request = GNMetadataSearch.parseFile(fileRequest);
        return this.search(connection, gnServiceURL, request);
    }

    private GNSearchResponse search(HTTPUtils connection, String gnServiceURL, Element request) throws GNLibException, GNServerException {
        String response = this.gnSearchMetadata(connection, gnServiceURL, request);
        Element eResponse = GNMetadataSearch.parse(response);
        GNSearchResponse searchResponse = new GNSearchResponse(eResponse);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Got response with " + searchResponse.getCount() + " metadata"));
        }
        return searchResponse;
    }

    private String gnSearchMetadata(HTTPUtils connection, String baseURL, Element gnRequest) throws GNServerException {
        String serviceURL = baseURL + "/srv/" + this.getLang() + "/xml.search";
        String resp = GNMetadataSearch.gnPost(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error searching metadata in GeoNetwork");
        }
        return resp;
    }

    private static String gnPost(HTTPUtils connection, String serviceURL, Element gnRequest) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String xmlReq = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        return connection.postXml(serviceURL, xmlReq);
    }

    private static Element parse(String s) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build((Reader)new StringReader(s)).detachRootElement();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error parsing GN response: " + s));
            throw new GNLibException("Error parsing GN response: " + ex.getMessage(), ex);
        }
    }

    private static Element parseFile(File file) throws GNLibException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            return (Element)doc.getRootElement().detach();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)("Error parsing input file " + file));
            throw new GNLibException("Error parsing input file " + file, ex);
        }
    }
}

