/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.util;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNSearchRequest {
    private Map<String, String> requestFields = new HashMap<String, String>();
    private static final XMLOutputter XML_OUTPUTTER = new XMLOutputter(Format.getPrettyFormat());

    public void addConfig(Config config, String value) {
        this.requestFields.put(config.name(), value);
    }

    public void addParam(Param param, String value) {
        this.requestFields.put(param.toString(), value);
    }

    public void addParam(String param, String value) {
        this.requestFields.put(param, value);
    }

    public String toXml() {
        return XML_OUTPUTTER.outputString(this.toElement());
    }

    public Element toElement() {
        Element request = new Element("request");
        for (Map.Entry<String, String> entry : this.requestFields.entrySet()) {
            request.addContent((Content)new Element(entry.getKey()).setText(entry.getValue()));
        }
        return request;
    }

    public static enum Param {
        any,
        title,
        abs("abstract"),
        themeKey,
        template,
        dynamic,
        download,
        digital,
        paper,
        group,
        attrset,
        dateFrom,
        dateTo,
        category,
        extFrom,
        extTo;

        private final String name;

        private Param() {
            this.name = this.name();
        }

        private Param(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum BBoxRelation {
        equal,
        overlaps,
        encloses,
        fullyOutsideOf,
        intersection,
        crosses,
        touches,
        within;

    }

    public static enum SortBy {
        relevance,
        rating,
        popularity,
        changeDate,
        title;

    }

    public static enum Config {
        remote,
        extended,
        timeout,
        hitsPerPage,
        similarity,
        sortBy;

    }
}

