/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.GNLogin;
import it.geosolutions.geonetwork.op.GNMetadataAdmin;
import it.geosolutions.geonetwork.op.GNMetadataDelete;
import it.geosolutions.geonetwork.op.GNMetadataGet;
import it.geosolutions.geonetwork.op.GNMetadataGetInfo;
import it.geosolutions.geonetwork.op.GNMetadataGetVersion;
import it.geosolutions.geonetwork.op.GNMetadataInsert;
import it.geosolutions.geonetwork.op.GNMetadataSearch;
import it.geosolutions.geonetwork.op.GNMetadataUpdate;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class GNClient {
    private static final Logger LOGGER = Logger.getLogger(GNClient.class);
    private HTTPUtils connection = new HTTPUtils();
    private final String gnServiceURL;

    public GNClient(String serviceURL) {
        this.gnServiceURL = serviceURL;
    }

    public boolean login(String username, String password) {
        return GNLogin.login(this.connection, this.gnServiceURL, username, password);
    }

    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertMetadata(this.connection, this.gnServiceURL, metadataFile, cfg);
    }

    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return GNMetadataInsert.insertRequest(this.connection, this.gnServiceURL, requestFile);
    }

    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        GNMetadataAdmin.setPriv(this.connection, this.gnServiceURL, metadataId, cfg);
    }

    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, searchRequest);
    }

    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return GNMetadataSearch.search(this.connection, this.gnServiceURL, fileRequest);
    }

    public Element get(Long id) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, id);
    }

    public Element get(String uuid) throws GNLibException, GNServerException {
        return GNMetadataGet.get(this.connection, this.gnServiceURL, uuid);
    }

    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        GNMetadataDelete.delete(this.connection, this.gnServiceURL, id);
    }

    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        String version = GNMetadataGetVersion.get(this.connection, this.gnServiceURL, id);
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, version, metadataFile);
    }

    public void updateMetadata(long id, int version, File metadataFile) throws GNLibException, GNServerException {
        GNMetadataUpdate.update(this.connection, this.gnServiceURL, id, Integer.toString(version), metadataFile);
    }

    public GNMetadataGetInfo.MetadataInfo getInfo(Long id, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.connection, this.gnServiceURL, id, forUpdate);
    }

    public GNMetadataGetInfo.MetadataInfo getInfo(String uuid, boolean forUpdate) throws GNLibException, GNServerException {
        return GNMetadataGetInfo.get(this.connection, this.gnServiceURL, uuid, forUpdate);
    }

    protected HTTPUtils getConnection() {
        return this.connection;
    }
}

