/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geonetwork.util;

import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNSearchResponse
implements Iterable<GNMetadata> {
    private static final Namespace NS_GEONET = Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork");
    private Element response;

    public GNSearchResponse(Element response) {
        this.response = response;
    }

    public int getCount() {
        String cnt = this.getSummary().getAttributeValue("count");
        return Integer.parseInt(cnt);
    }

    public int getFrom() {
        String cnt = this.response.getAttributeValue("from");
        return Integer.parseInt(cnt);
    }

    public int getTo() {
        String cnt = this.response.getAttributeValue("to");
        return Integer.parseInt(cnt);
    }

    public boolean isCompleteResponse() {
        int cnt = this.getCount();
        return cnt == 0 || cnt == this.getTo() - this.getFrom() + 1;
    }

    public Element getSummary() {
        return this.response.getChild("summary");
    }

    public GNMetadata getMetadata(int index) {
        Element metadata = (Element)this.response.getChildren("metadata").get(index);
        return new GNMetadata(metadata);
    }

    @Override
    public Iterator<GNMetadata> iterator() {
        return new Iterator<GNMetadata>(){
            private List<Element> list;
            private Iterator<Element> iter;
            {
                this.list = GNSearchResponse.this.response.getChildren("metadata");
                this.iter = this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public GNMetadata next() {
                return new GNMetadata(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return "GNSearchResponse[" + outputter.outputString(this.response) + ']';
    }

    public static class GNMetadata {
        private Element metadata;

        public GNMetadata(Element metadata) {
            this.metadata = metadata;
        }

        public Element getInfo() {
            return this.metadata.getChild("info", NS_GEONET);
        }

        public Long getId() {
            return Long.valueOf(this.getInfo().getChildText("id"));
        }

        public String getUUID() {
            return this.getInfo().getChildText("uuid");
        }

        public String getSchema() {
            return this.getInfo().getChildText("schema");
        }
    }
}

