/*
 *    GeoTools - OpenSource mapping toolkit
 *    http://geotools.org
 *    (C) 2002-2006, GeoTools Project Managment Committee (PMC)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.opengis.filter.expression.PropertyName;


/**
 * The geotools representation of the PropertyName tag in an xml encoded
 * filter.
 * <p>
 * It should handle xpath attributePaths of features, and should
 * report the attribute found at the attributePath of a feature.
 * </p>
 * @source $URL: http://svn.geotools.org/geotools/tags/2.3.3/module/api/src/org/geotools/filter/AttributeExpression.java $
 * @version $Id: AttributeExpression.java 21455 2006-09-17 13:17:01Z jdeolive $
 * 
 * @deprecated use {@link org.opengis.filter.expression.PropertyName}
 */
public interface AttributeExpression extends Expression, PropertyName {
    /**
     * Sets the path of the attribute of this expression. For simple,
     * non-nested, features the 'path' is simply the name of an  attribute.
     *
     * @param attributePath A string of the path.
     *
     * @throws IllegalFilterException if the path is not valid.
     *
     * @deprecated use {@link PropertyName#setPropertyName(String)}
     *
     */
    void setAttributePath(String attributePath) throws IllegalFilterException;

    /**
     * Gets the attribute value at the path held by this expression from the
     * feature.
     *
     * @param feature the feature to get this attribute from.
     *
     * @return the value of the attribute found by this expression.
     *
     * @deprecated use {@link org.opengis.filter.expression.Expression#evaluate(Feature)()}
     */
    Object getValue(Feature feature);

    /**
     * Gets the attribute path of this expression.
     *
     * @return the attribute to be queried.
     *
     * @deprecated use {@link PropertyName#getPropertyName()}
     */
    String getAttributePath();
}
