/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.feature.AttributeType;

public class IllegalAttributeException
extends Exception {
    private static final long serialVersionUID = -4964013824521988182L;
    private final AttributeType expected;
    private final Object invalid;

    public IllegalAttributeException(String message) {
        super(message);
        this.expected = null;
        this.invalid = null;
    }

    public IllegalAttributeException(AttributeType expected, Object invalid) {
        this(expected, invalid, null);
    }

    public IllegalAttributeException(AttributeType expected, Object invalid, Throwable cause) {
        super(IllegalAttributeException.errorMessage(expected, invalid), cause);
        this.expected = expected;
        this.invalid = invalid;
    }

    public String toString() {
        if (this.expected == null && this.invalid == null) {
            return super.toString();
        }
        String message = "IllegalAttribute: " + (this.expected == null ? "null" : this.expected.getType().getName());
        message = message + " , but got " + (this.invalid == null ? "null" : this.invalid.getClass().getName());
        return message;
    }

    static String errorMessage(AttributeType expected, Object invalid) {
        String message = "expected " + (expected == null ? "null" : expected.getType().getName());
        message = message + " , but got " + (invalid == null ? "null" : invalid.getClass().getName());
        return message;
    }
}

