/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Date;
import org.geotools.feature.Feature;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class ConstantExpression
implements LiteralExpression,
Cloneable {
    public static final ConstantExpression NULL = ConstantExpression.constant(null);
    public static final ConstantExpression BLACK = ConstantExpression.color(Color.BLACK);
    public static final ConstantExpression ZERO = ConstantExpression.constant(0);
    public static final ConstantExpression ONE = ConstantExpression.constant(1);
    public static final ConstantExpression TWO = ConstantExpression.constant(2);
    public static final ConstantExpression UNNAMED = ConstantExpression.constant("");
    final short type;
    Object value;

    protected ConstantExpression(Object value) {
        this(ConstantExpression.type(value), value);
    }

    protected ConstantExpression(short type, Object value) {
        this.type = type;
        this.value = value;
    }

    public final void setLiteral(Object literal) throws IllegalFilterException {
        throw new UnsupportedOperationException("Default value is immutable");
    }

    public final Object getValue(Feature feature) {
        return this.evaluate(feature);
    }

    public Object evaluate(Feature feature) {
        return this.getValue();
    }

    public Object evaluate(Object object) {
        return this.getValue();
    }

    public Object evaluate(Object object, Class context) {
        if (this.value == null || this.value.getClass().equals(context)) {
            return this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object constant) {
        throw new UnsupportedOperationException("Default value is immutable");
    }

    public short getType() {
        return this.type;
    }

    public final Object getLiteral() {
        return this.getValue();
    }

    public void accept(final FilterVisitor visitor) {
        this.accept(new ExpressionVisitor(){

            public Object visit(Add expression, Object extraData) {
                return null;
            }

            public Object visit(Divide expression, Object extraData) {
                return null;
            }

            public Object visit(Function expression, Object extraData) {
                return null;
            }

            public Object visit(Literal expression, Object extraData) {
                visitor.visit(ConstantExpression.this);
                return null;
            }

            public Object visit(Multiply expression, Object extraData) {
                return null;
            }

            public Object visit(PropertyName expression, Object extraData) {
                return null;
            }

            public Object visit(Subtract expression, Object extraData) {
                return null;
            }

            public Object visit(NilExpression arg0, Object arg1) {
                return null;
            }
        }, null);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Literal)this, extraData);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ConstantExpression(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LiteralExpression)) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)obj;
        Object otherLiteral = other.getValue();
        if (this.value == null) {
            return otherLiteral == null;
        }
        if (this.value.getClass().isAssignableFrom(otherLiteral.getClass())) {
            return this.value.equals(other.getValue());
        }
        if (this.value instanceof Number && otherLiteral instanceof Number) {
            Number myNumber = (Number)this.value;
            Number otherNumber = (Number)otherLiteral;
            return myNumber.doubleValue() == otherNumber.doubleValue();
        }
        String myString = this.value.toString();
        String otherString = otherLiteral.toString();
        return myString.equals(otherString);
    }

    public int hashCode() {
        if (this.value instanceof Geometry || this.value instanceof Date) {
            return this.value.hashCode();
        }
        return this.value == null ? 0 : this.value.toString().hashCode();
    }

    public String toString() {
        if (this.value instanceof Color) {
            Color color = (Color)this.value;
            String redCode = Integer.toHexString(color.getRed());
            String greenCode = Integer.toHexString(color.getGreen());
            String blueCode = Integer.toHexString(color.getBlue());
            if (redCode.length() == 1) {
                redCode = "0" + redCode;
            }
            if (greenCode.length() == 1) {
                greenCode = "0" + greenCode;
            }
            if (blueCode.length() == 1) {
                blueCode = "0" + blueCode;
            }
        }
        return this.value == null ? "NULL" : this.value.toString();
    }

    public static ConstantExpression color(Color color) {
        if (color == null) {
            return NULL;
        }
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        if (redCode.length() == 1) {
            redCode = "0" + redCode;
        }
        if (greenCode.length() == 1) {
            greenCode = "0" + greenCode;
        }
        if (blueCode.length() == 1) {
            blueCode = "0" + blueCode;
        }
        String colorCode = "#" + redCode + greenCode + blueCode;
        return new ConstantExpression(colorCode);
    }

    public static ConstantExpression constant(double number) {
        return new ConstantExpression(new Double(number));
    }

    public static ConstantExpression constant(int number) {
        return new ConstantExpression(new Integer(number));
    }

    public static ConstantExpression constant(Object value) {
        return new ConstantExpression(value);
    }

    static short type(Object value) {
        if (value instanceof Number) {
            if (value instanceof Double) {
                return 101;
            }
            if (value instanceof BigDecimal) {
                return 101;
            }
            return 102;
        }
        if (value instanceof Geometry) {
            return 104;
        }
        return 103;
    }
}

