/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DefaultCoordinateSequenceTransformer
implements CoordinateSequenceTransformer {
    private final transient double[] buffer = new double[96];
    private final CoordinateSequenceFactory csFactory = DefaultCoordinateSequenceFactory.instance();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CoordinateSequence transform(CoordinateSequence sequence, MathTransform transform) throws TransformException {
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        int size = sequence.size();
        Coordinate[] tcs = new Coordinate[size];
        int bufferCapacity = this.buffer.length / Math.max(sourceDim, targetDim);
        int remainingBeforeFlush = Math.min(bufferCapacity, size);
        int ib = 0;
        int it = 0;
        for (int i = 0; i < size; ++i) {
            Coordinate c = sequence.getCoordinate(i);
            switch (sourceDim) {
                default: {
                    throw new MismatchedDimensionException();
                }
                case 3: {
                    this.buffer[ib + 2] = c.z;
                }
                case 2: {
                    this.buffer[ib + 1] = c.y;
                }
                case 1: {
                    this.buffer[ib] = c.x;
                }
                case 0: 
            }
            ib += sourceDim;
            if (--remainingBeforeFlush != 0) continue;
            if (!$assertionsDisabled && ib % sourceDim != 0) {
                throw new AssertionError();
            }
            int n = ib / sourceDim;
            transform.transform(this.buffer, 0, this.buffer, 0, n);
            ib = 0;
            for (int j = 0; j < n; ++j) {
                Coordinate t;
                switch (targetDim) {
                    default: {
                        throw new MismatchedDimensionException();
                    }
                    case 3: {
                        t = new Coordinate(this.buffer[ib++], this.buffer[ib++], this.buffer[ib++]);
                        break;
                    }
                    case 2: {
                        t = new Coordinate(this.buffer[ib++], this.buffer[ib++]);
                        break;
                    }
                    case 1: {
                        t = new Coordinate(this.buffer[ib++], Double.NaN);
                        break;
                    }
                    case 0: {
                        t = new Coordinate(Double.NaN, Double.NaN);
                    }
                }
                tcs[it++] = t;
            }
            if (!$assertionsDisabled && ib != n * targetDim) {
                throw new AssertionError();
            }
            ib = 0;
            remainingBeforeFlush = Math.min(bufferCapacity, size - (i + 1));
        }
        if (!$assertionsDisabled && it != tcs.length) {
            throw new AssertionError(tcs.length - it);
        }
        return this.csFactory.create(tcs);
    }

    static {
        $assertionsDisabled = !DefaultCoordinateSequenceTransformer.class.desiredAssertionStatus();
    }
}

