/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.geometry.ShapeUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class JTS {
    private static final GeneralDirectPosition[] POSITIONS;
    private static final Map CALCULATORS;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JTS() {
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)name));
        }
    }

    public static Envelope transform(Envelope envelope, MathTransform transform) throws TransformException {
        return JTS.transform(envelope, null, transform, 5);
    }

    public static Envelope transform(Envelope sourceEnvelope, Envelope targetEnvelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        JTS.ensureNonNull("sourceEnvelope", sourceEnvelope);
        JTS.ensureNonNull("transform", transform);
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new MismatchedDimensionException(Errors.format((int)15, (Object)Utilities.getShortClassName((Object)transform)));
        }
        double[] coordinates = new double[4 * ++npoints * 2];
        double xmin = sourceEnvelope.getMinX();
        double xmax = sourceEnvelope.getMaxX();
        double ymin = sourceEnvelope.getMinY();
        double ymax = sourceEnvelope.getMaxY();
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[offset++] = xmin;
            coordinates[offset++] = ymin + dy;
            coordinates[offset++] = xmin + dx;
            coordinates[offset++] = ymax;
            coordinates[offset++] = xmax;
            coordinates[offset++] = ymax - dy;
            coordinates[offset++] = xmax - dx;
            coordinates[offset++] = ymin;
        }
        if (!$assertionsDisabled && offset != coordinates.length) {
            throw new AssertionError();
        }
        JTS.xform(transform, coordinates, coordinates);
        if (targetEnvelope == null) {
            targetEnvelope = new Envelope();
        }
        t = 0;
        while (t < offset) {
            targetEnvelope.expandToInclude(coordinates[t++], coordinates[t++]);
        }
        return targetEnvelope;
    }

    public static Geometry transform(Geometry geom, MathTransform transform) throws MismatchedDimensionException, TransformException {
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        transformer.setMathTransform(transform);
        return transformer.transform(geom);
    }

    public static Coordinate transform(Coordinate source, Coordinate dest, MathTransform transform) throws TransformException {
        JTS.ensureNonNull("source", source);
        JTS.ensureNonNull("transform", transform);
        if (dest == null) {
            dest = new Coordinate();
        }
        double[] array = new double[transform.getSourceDimensions()];
        JTS.copy(source, array);
        transform.transform(array, 0, array, 0, 1);
        switch (transform.getTargetDimensions()) {
            case 3: {
                dest.z = array[2];
            }
            case 2: {
                dest.y = array[1];
            }
            case 1: {
                dest.x = array[0];
            }
        }
        return dest;
    }

    public static Envelope toGeographic(Envelope envelope, CoordinateReferenceSystem crs) throws TransformException {
        MathTransform transform;
        if (CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
            return envelope;
        }
        try {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        }
        catch (FactoryException exception) {
            throw new TransformPathNotFoundException(Errors.format((int)26, (Object)((Object)exception)));
        }
        return JTS.transform(envelope, transform);
    }

    public static void xform(MathTransform transform, double[] src, double[] dest) throws TransformException {
        JTS.ensureNonNull("transform", transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int i = 0; i < src.length; i += sourceDim) {
            try {
                transform.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(dest, j, dest, i, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, i - targetDim, dest, i, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }

    public static synchronized double orthodromicDistance(Coordinate p1, Coordinate p2, CoordinateReferenceSystem crs) throws TransformException {
        JTS.ensureNonNull("p1", p1);
        JTS.ensureNonNull("p2", p2);
        JTS.ensureNonNull("crs", crs);
        GeodeticCalculator gc = (GeodeticCalculator)CALCULATORS.get(crs);
        if (gc == null) {
            gc = new GeodeticCalculator(crs);
            CALCULATORS.put(crs, gc);
        }
        if (!$assertionsDisabled && !crs.equals(gc.getCoordinateReferenceSystem())) {
            throw new AssertionError(crs);
        }
        GeneralDirectPosition pos = POSITIONS[Math.min(POSITIONS.length - 1, crs.getCoordinateSystem().getDimension())];
        pos.setCoordinateReferenceSystem(crs);
        JTS.copy(p1, pos.ordinates);
        gc.setStartingPosition((Position)pos);
        JTS.copy(p2, pos.ordinates);
        gc.setDestinationPosition((Position)pos);
        return gc.getOrthodromicDistance();
    }

    public static void copy(Coordinate point, double[] ordinates) {
        JTS.ensureNonNull("point", point);
        JTS.ensureNonNull("ordinates", ordinates);
        switch (ordinates.length) {
            default: {
                Arrays.fill(ordinates, 3, ordinates.length, Double.NaN);
            }
            case 3: {
                ordinates[2] = point.z;
            }
            case 2: {
                ordinates[1] = point.y;
            }
            case 1: {
                ordinates[0] = point.x;
            }
            case 0: 
        }
    }

    public static Geometry shapeToGeometry(Shape shape, GeometryFactory factory) {
        JTS.ensureNonNull("shape", shape);
        JTS.ensureNonNull("factory", factory);
        PathIterator iterator = shape.getPathIterator(null, ShapeUtilities.getFlatness((Shape)shape));
        double[] buffer = new double[6];
        ArrayList<Object> coords = new ArrayList<Object>();
        ArrayList<Object> lines = new ArrayList<Object>();
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(buffer)) {
                case 4: {
                    if (coords.isEmpty()) break;
                    coords.add((Coordinate[])coords.get(0));
                    lines.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
                    coords.clear();
                    break;
                }
                case 0: {
                    if (!coords.isEmpty()) {
                        lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                        coords.clear();
                    }
                }
                case 1: {
                    coords.add(new Coordinate(buffer[0], buffer[1]));
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            iterator.next();
        }
        if (!coords.isEmpty()) {
            lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
        }
        switch (lines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (LineString)lines.get(0);
            }
        }
        return factory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Envelope2D getEnvelope2D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        CoordinateReferenceSystem crs2D;
        JTS.ensureNonNull("envelope", envelope);
        JTS.ensureNonNull("crs", crs);
        if (envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope referenced = (ReferencedEnvelope)envelope;
            CoordinateReferenceSystem implicitCRS = referenced.getCoordinateReferenceSystem();
            if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)implicitCRS)) {
                throw new IllegalArgumentException(Errors.format((int)186, (Object)crs.getName().getCode(), (Object)implicitCRS.getName().getCode()));
            }
        }
        try {
            crs2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)crs);
        }
        catch (TransformException exception) {
            throw new MismatchedDimensionException(exception.getLocalizedMessage());
        }
        return new Envelope2D(crs2D, envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
    }

    public static Polygon toGeometry(Envelope e) {
        GeometryFactory gf = new GeometryFactory();
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMinX(), e.getMinY())}), null);
    }

    public static void checkCoordinatesRange(Geometry geom, CoordinateReferenceSystem crs) throws PointOutsideEnvelopeException {
        boolean yUnbounded;
        CoordinateSystemAxis x = crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis y = crs.getCoordinateSystem().getAxis(1);
        boolean xUnbounded = Double.isInfinite(x.getMinimumValue()) && Double.isInfinite(x.getMaximumValue());
        boolean bl = yUnbounded = Double.isInfinite(y.getMinimumValue()) && Double.isInfinite(y.getMaximumValue());
        if (xUnbounded && yUnbounded) {
            return;
        }
        Coordinate[] c = geom.getCoordinates();
        for (int i = 0; i < c.length; ++i) {
            if (!xUnbounded && (c[i].x < x.getMinimumValue() || c[i].x > x.getMaximumValue())) {
                throw new PointOutsideEnvelopeException(c[i].x + " outside of (" + x.getMinimumValue() + "," + x.getMaximumValue() + ")");
            }
            if (yUnbounded || !(c[i].y < y.getMinimumValue()) && !(c[i].y > y.getMaximumValue())) continue;
            throw new PointOutsideEnvelopeException(c[i].y + " outside of (" + y.getMinimumValue() + "," + y.getMaximumValue() + ")");
        }
    }

    static {
        $assertionsDisabled = !JTS.class.desiredAssertionStatus();
        POSITIONS = new GeneralDirectPosition[4];
        for (int i = 0; i < POSITIONS.length; ++i) {
            JTS.POSITIONS[i] = new GeneralDirectPosition(i);
        }
        CALCULATORS = new HashMap();
    }
}

