/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReferencedEnvelope
extends Envelope
implements org.opengis.geometry.Envelope,
BoundingBox {
    private static final long serialVersionUID = -3188702602373537163L;
    private final CoordinateReferenceSystem crs;

    public ReferencedEnvelope(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Rectangle2D rectangle, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), crs);
    }

    public ReferencedEnvelope(ReferencedEnvelope envelope) throws MismatchedDimensionException {
        super((Envelope)envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(BoundingBox bbox) throws MismatchedDimensionException {
        this(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), bbox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope(org.opengis.geometry.Envelope envelope) throws MismatchedDimensionException {
        super(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1));
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    private static Envelope getJTSEnvelope(BoundingBox bbox) {
        if (bbox instanceof Envelope) {
            return (Envelope)bbox;
        }
        return new ReferencedEnvelope(bbox);
    }

    private void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension != expected) {
                throw new MismatchedDimensionException(Errors.format((int)69, (Object)this.crs.getName().getCode(), (Object)new Integer(dimension), (Object)new Integer(expected)));
            }
        }
    }

    private void ensureCompatibleReferenceSystem(BoundingBox bbox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = bbox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata((Object)this.crs, (Object)other)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)197));
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getCenter(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getLength(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.crs, this.getMinX(), this.getMinY());
    }

    public DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    public boolean isEmpty() {
        return super.isNull();
    }

    public boolean contains(DirectPosition pos) {
        return super.contains(pos.getOrdinate(0), pos.getOrdinate(1));
    }

    public boolean contains(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.contains(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    public boolean intersects(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.intersects(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    public void include(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        super.expandToInclude(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }

    public void setBounds(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        super.init(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return this.transform(targetCRS, true);
        }
        catch (FactoryException e) {
            throw new TransformException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient) throws TransformException, FactoryException {
        return this.transform(targetCRS, lenient, 5);
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient, int numPointsForTransformation) throws TransformException, FactoryException {
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)lenient).createOperation(this.crs, targetCRS);
        GeneralEnvelope transformed = CRS.transform((CoordinateOperation)operation, (org.opengis.geometry.Envelope)this);
        transformed.setCoordinateReferenceSystem(targetCRS);
        ReferencedEnvelope target = new ReferencedEnvelope((org.opengis.geometry.Envelope)transformed);
        MathTransform transform = operation.getMathTransform();
        JTS.transform(this, target, transform, numPointsForTransformation);
        return target;
    }

    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)((Object)object)).crs : null;
            return Utilities.equals((Object)this.crs, (Object)otherCRS);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName((Object)((Object)this))).append('[');
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        return buffer.append(']').toString();
    }

    public static ReferencedEnvelope reference(Envelope e) {
        if (e instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)e;
        }
        return new ReferencedEnvelope(e, null);
    }
}

