/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.util;

public final class UnlimitedInteger
extends Number {
    private static final long serialVersionUID = 4748246369364771836L;
    private final UnlimitedInteger POSITIVE_INFINITY = new UnlimitedInteger(Integer.MAX_VALUE);
    private final UnlimitedInteger NEGATIVE_INFINITY = new UnlimitedInteger(Integer.MIN_VALUE);
    private final int value;

    public UnlimitedInteger(int n) {
        this.value = n;
    }

    public boolean isInfinite() {
        return this.value == Integer.MAX_VALUE || this.value == Integer.MIN_VALUE;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return Float.POSITIVE_INFINITY;
            }
            case -2147483648: {
                return Float.NEGATIVE_INFINITY;
            }
        }
        return this.value;
    }

    public double doubleValue() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return Double.POSITIVE_INFINITY;
            }
            case -2147483648: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return "\u221e";
            }
            case -2147483648: {
                return "-\u221e";
            }
        }
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof UnlimitedInteger && ((UnlimitedInteger)object).value == this.value;
    }
}

