/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerMessageFormattingTest {
    LoggerContext lc;
    ListAppender<ILoggingEvent> listAppender;

    @Before
    public void setUp() {
        this.lc = new LoggerContext();
        Logger logger = this.lc.getLogger("ROOT");
        this.listAppender = new ListAppender();
        this.listAppender.setContext((Context)this.lc);
        this.listAppender.start();
        logger.addAppender(this.listAppender);
    }

    @Test
    public void testFormattingOneArg() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}", (Object)new Integer(12));
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertEquals((Object)"12", (Object)event.getFormattedMessage());
    }

    @Test
    public void testFormattingTwoArg() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}-{}", (Object)new Integer(12), (Object)new Integer(13));
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertEquals((Object)"12-13", (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormatting() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test", (Object)new Integer(12), (Object)new Integer(13));
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertEquals((Object)"test", (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormatting2() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test");
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertEquals((Object)"test", (Object)event.getFormattedMessage());
    }

    @Test
    public void testMessageConverter() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}", (Object)12);
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)this.lc);
        layout.setPattern("%m");
        layout.start();
        String formattedMessage = layout.doLayout(event);
        Assert.assertEquals((Object)"12", (Object)formattedMessage);
    }
}

