/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.JaninoEventEvaluator;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.boolex.Matcher;
import ch.qos.logback.core.filter.EvaluatorFilter;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;

public class JaninoEventEvaluatorTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(ConverterTest.class);
    Matcher matcherX = new Matcher();
    JaninoEventEvaluator jee = new JaninoEventEvaluator();
    int diff = RandomUtil.getPositiveInt();
    static final long LEN = 10000L;

    public JaninoEventEvaluatorTest() {
        this.jee.setContext((Context)this.loggerContext);
        this.matcherX.setName("x");
        this.matcherX.setRegex("^Some\\s.*");
        this.matcherX.start();
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    @Test
    public void testBasic() throws Exception {
        this.jee.setExpression("message.equals(\"Some message\")");
        this.jee.start();
        StatusPrinter.print((Context)this.loggerContext);
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void testLevel() throws Exception {
        this.jee.setExpression("level > DEBUG");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void testtimeStamp() throws Exception {
        this.jee.setExpression("timeStamp > 10");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void testWithMatcher() throws Exception {
        this.jee.setExpression("x.matches(message)");
        this.jee.addMatcher(this.matcherX);
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void mdcAsString() throws Exception {
        String k = "key" + this.diff;
        MDC.put((String)("key" + this.diff), (String)("value" + this.diff));
        this.jee.setExpression("((String) mdc.get(\"" + k + "\")).contains(\"alue\")");
        this.jee.start();
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.loggerContext);
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
        MDC.remove((String)k);
    }

    @Test
    public void marker() throws Exception {
        this.jee.setExpression("marker.contains(\"BLUE\")");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void withNullMarker_LBCORE_118() throws Exception {
        this.jee.setExpression("marker.contains(\"BLUE\")");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        try {
            this.jee.evaluate((Object)event);
            Assert.fail((String)"We should not reach this point");
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @Test
    public void evaluatorFilterWithNullMarker_LBCORE_118() throws Exception {
        EvaluatorFilter ef = new EvaluatorFilter();
        ef.setContext((Context)this.loggerContext);
        ef.setOnMatch(FilterReply.ACCEPT);
        ef.setOnMismatch(FilterReply.DENY);
        this.jee.setExpression("marker.contains(\"BLUE\")");
        this.jee.start();
        ef.setEvaluator((EventEvaluator)this.jee);
        ef.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)ef.decide((Object)event));
    }

    @Test
    public void testComplex() throws Exception {
        this.jee.setExpression("level >= INFO && x.matches(message) && marker.contains(\"BLUE\")");
        this.jee.addMatcher(this.matcherX);
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void testBogusExp1() {
        this.jee.setExpression("mzzzz.get(\"key\").equals(null)");
        this.jee.setName("bogus");
        this.jee.start();
        Assert.assertFalse((boolean)this.jee.isStarted());
    }

    @Test
    public void testBogusExp2() {
        this.jee.setExpression("mdc.get(\"keyXN89\").equals(null)");
        this.jee.setName("bogus");
        this.jee.start();
        Assert.assertTrue((boolean)this.jee.isStarted());
        LoggingEvent event = this.makeLoggingEvent(null);
        for (int i = 0; i < 4; ++i) {
            try {
                this.jee.evaluate((Object)event);
                Assert.fail((String)"should throw an exception");
                continue;
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)this.jee.isStarted());
    }

    void loop(JaninoEventEvaluator jee, String msg) throws Exception {
        LoggingEvent event = this.makeLoggingEvent(null);
        int i = 0;
        while ((long)i < 10000L) {
            jee.evaluate((Object)event);
            ++i;
        }
    }

    @Test
    public void testLoop1() throws Exception {
        this.jee.setExpression("timeStamp > 10");
        this.jee.start();
        this.loop(this.jee, "timestamp > 10]: ");
    }

    @Test
    public void testLoop2() throws Exception {
        this.jee.setExpression("x.matches(message)");
        this.jee.addMatcher(this.matcherX);
        this.jee.start();
        this.loop(this.jee, "x.matches(message): ");
    }

    @Test
    public void throwable_LBCLASSIC_155_I() throws EvaluationException {
        this.jee.setExpression("throwable instanceof java.io.IOException");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(new IOException(""));
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void throwable_LBCLASSIC_155_II() throws EvaluationException {
        this.jee.setExpression("throwableProxy.getClassName().contains(\"IO\")");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(new IOException(""));
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }

    @Test
    public void nullMDC() throws EvaluationException {
        MDC.clear();
        this.jee.setExpression("mdc.isEmpty()");
        this.jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)this.jee.evaluate((Object)event));
    }
}

