/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.OnMarkerEvaluator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MarkerFactory;

public class OnMarkerEvaluatorTest {
    LoggerContext lc = new LoggerContext();
    LoggingEvent event = this.makeEvent();
    OnMarkerEvaluator evaluator = new OnMarkerEvaluator();

    @Before
    public void before() {
        this.evaluator.setContext((Context)this.lc);
    }

    @Test
    public void smoke() throws EvaluationException {
        this.evaluator.addMarker("M");
        this.evaluator.start();
        this.event.setMarker(MarkerFactory.getMarker((String)"M"));
        Assert.assertTrue((boolean)this.evaluator.evaluate((ILoggingEvent)this.event));
    }

    @Test
    public void nullMarkerInEvent() throws EvaluationException {
        this.evaluator.addMarker("M");
        this.evaluator.start();
        Assert.assertFalse((boolean)this.evaluator.evaluate((ILoggingEvent)this.event));
    }

    @Test
    public void nullMarkerInEvaluator() throws EvaluationException {
        this.evaluator.addMarker("M");
        this.evaluator.start();
        Assert.assertFalse((boolean)this.evaluator.evaluate((ILoggingEvent)this.event));
    }

    LoggingEvent makeEvent() {
        return new LoggingEvent("x", this.lc.getLogger("x"), Level.DEBUG, "msg", null, null);
    }
}

