/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.core.testUtil.RandomUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.junit.Assert;

public class DBAppenderH2TestFixture {
    public static final String H2_DRIVER_CLASS = "org.h2.Driver";
    String url = null;
    String user = "sa";
    String password = "";
    H2Mode mode = H2Mode.MEM;
    int diff = RandomUtil.getPositiveInt();
    Connection connection;

    public void setUp() throws SQLException {
        switch (this.mode) {
            case NET: {
                this.url = "jdbc:h2:tcp://localhost:4808/test";
                break;
            }
            case MEM: {
                this.url = "jdbc:h2:mem:test" + this.diff;
                break;
            }
            case FILE: {
                this.url = "jdbc:hsqldb:file:test;sql.enforce_strict_size=true";
            }
        }
        this.connection = this.newConnection();
        this.createTables();
    }

    public void tearDown() throws SQLException {
        this.dropTables();
        this.connection.close();
    }

    Connection newConnection() throws SQLException {
        System.out.println("url=" + this.url);
        Driver driver = Driver.load();
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        return driver.connect(this.url, props);
    }

    private void createTables() throws SQLException {
        Assert.assertNotNull((Object)this.connection);
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT (");
        buf.append("TIMESTMP BIGINT NOT NULL,");
        buf.append("FORMATTED_MESSAGE LONGVARCHAR NOT NULL,");
        buf.append("LOGGER_NAME VARCHAR(256) NOT NULL,");
        buf.append("LEVEL_STRING VARCHAR(256) NOT NULL,");
        buf.append("THREAD_NAME VARCHAR(256),");
        buf.append("REFERENCE_FLAG SMALLINT,");
        buf.append("ARG0 VARCHAR(256),");
        buf.append("ARG1 VARCHAR(256),");
        buf.append("ARG2 VARCHAR(256),");
        buf.append("ARG3 VARCHAR(256),");
        buf.append("CALLER_FILENAME VARCHAR(256), ");
        buf.append("CALLER_CLASS VARCHAR(256), ");
        buf.append("CALLER_METHOD VARCHAR(256), ");
        buf.append("CALLER_LINE CHAR(4), ");
        buf.append("EVENT_ID IDENTITY NOT NULL);");
        this.executeQuery(this.connection, buf.toString());
        buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT_PROPERTY (");
        buf.append("EVENT_ID BIGINT NOT NULL,");
        buf.append("MAPPED_KEY  VARCHAR(254) NOT NULL,");
        buf.append("MAPPED_VALUE LONGVARCHAR,");
        buf.append("PRIMARY KEY(EVENT_ID, MAPPED_KEY),");
        buf.append("FOREIGN KEY (EVENT_ID) REFERENCES LOGGING_EVENT(EVENT_ID));");
        this.executeQuery(this.connection, buf.toString());
        buf = new StringBuilder();
        buf.append("CREATE TABLE LOGGING_EVENT_EXCEPTION (");
        buf.append("EVENT_ID BIGINT NOT NULL,");
        buf.append("I SMALLINT NOT NULL,");
        buf.append("TRACE_LINE VARCHAR(256) NOT NULL,");
        buf.append("PRIMARY KEY(EVENT_ID, I),");
        buf.append("FOREIGN KEY (EVENT_ID) REFERENCES LOGGING_EVENT(EVENT_ID));");
        this.executeQuery(this.connection, buf.toString());
    }

    private void dropTables() throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT_EXCEPTION IF EXISTS;");
        this.executeQuery(this.connection, buf.toString());
        buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT_PROPERTY IF EXISTS;");
        this.executeQuery(this.connection, buf.toString());
        buf = new StringBuilder();
        buf.append("DROP TABLE LOGGING_EVENT IF EXISTS;");
        this.executeQuery(this.connection, buf.toString());
    }

    private void executeQuery(Connection conn, String expression) throws SQLException {
        Statement st = null;
        st = conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            throw new IllegalStateException("db error : " + expression);
        }
        st.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum H2Mode {
        MEM,
        FILE,
        NET;

    }
}

