/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.net.JMSQueueAppender;
import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.net.mock.MockQueue;
import ch.qos.logback.classic.net.mock.MockQueueConnectionFactory;
import ch.qos.logback.classic.net.mock.MockQueueSender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.MockInitialContext;
import ch.qos.logback.classic.util.MockInitialContextFactory;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Serializable;
import javax.jms.ObjectMessage;
import junit.framework.TestCase;

public class JMSQueueAppenderTest
extends TestCase {
    Context context;
    JMSQueueAppender appender;
    PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    protected void setUp() throws Exception {
        this.context = new ContextBase();
        this.appender = new JMSQueueAppender();
        this.appender.setContext(this.context);
        this.appender.setName("jmsQueue");
        this.appender.qcfBindingName = "queueCnxFactory";
        this.appender.queueBindingName = "testQueue";
        this.appender.setProviderURL("url");
        this.appender.setInitialContextFactoryName(MockInitialContextFactory.class.getName());
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(this.appender.qcfBindingName, new MockQueueConnectionFactory());
        mic.map.put(this.appender.queueBindingName, new MockQueue(this.appender.queueBindingName));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.appender = null;
        this.context = null;
        super.tearDown();
    }

    public void testAppendOk() {
        this.appender.start();
        ILoggingEvent le = this.createLoggingEvent();
        this.appender.append(le);
        MockQueueSender qs = (MockQueueSender)this.appender.queueSender;
        JMSQueueAppenderTest.assertEquals((int)1, (int)qs.getMessageList().size());
        ObjectMessage message = (ObjectMessage)qs.getMessageList().get(0);
        try {
            Serializable witness = this.pst.transform((Object)le);
            JMSQueueAppenderTest.assertEquals((Object)witness, (Object)message.getObject());
        }
        catch (Exception e) {
            JMSQueueAppenderTest.fail();
        }
    }

    public void testAppendFailure() {
        this.appender.start();
        this.appender.queueSender = null;
        ILoggingEvent le = this.createLoggingEvent();
        for (int i = 1; i <= 3; ++i) {
            this.appender.append(le);
            JMSQueueAppenderTest.assertEquals((int)i, (int)this.context.getStatusManager().getCount());
            JMSQueueAppenderTest.assertTrue((boolean)this.appender.isStarted());
        }
        this.appender.append(le);
        JMSQueueAppenderTest.assertEquals((int)4, (int)this.context.getStatusManager().getCount());
        JMSQueueAppenderTest.assertFalse((boolean)this.appender.isStarted());
    }

    public void testStartMinimalInfo() {
        this.appender.setProviderURL(null);
        this.appender.start();
        JMSQueueAppenderTest.assertTrue((boolean)this.appender.isStarted());
        try {
            JMSQueueAppenderTest.assertEquals((String)this.appender.queueBindingName, (String)this.appender.queueSender.getQueue().getQueueName());
        }
        catch (Exception e) {
            JMSQueueAppenderTest.fail();
        }
    }

    public void testStartUserPass() {
        this.appender.setUserName("test");
        this.appender.setPassword("test");
        this.appender.start();
        JMSQueueAppenderTest.assertTrue((boolean)this.appender.isStarted());
        try {
            JMSQueueAppenderTest.assertEquals((String)this.appender.queueBindingName, (String)this.appender.queueSender.getQueue().getQueueName());
        }
        catch (Exception e) {
            JMSQueueAppenderTest.fail();
        }
    }

    public void testStartFails() {
        this.appender.queueBindingName = null;
        this.appender.start();
        JMSQueueAppenderTest.assertFalse((boolean)this.appender.isStarted());
    }

    private ILoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent();
        le.setLevel(Level.DEBUG);
        le.setMessage("test message");
        le.setTimeStamp(System.currentTimeMillis());
        le.setThreadName(Thread.currentThread().getName());
        return le;
    }
}

