/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.JMSTopicAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import org.slf4j.LoggerFactory;

public class JMSTopicAppenderTestApp {
    public static void main(String[] args) {
        Logger logger = (Logger)LoggerFactory.getLogger(JMSTopicAppenderTestApp.class);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        JMSTopicAppender appender = new JMSTopicAppender();
        appender.setContext((Context)lc);
        appender.setName("jmsTopic");
        appender.setInitialContextFactoryName("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        appender.setProviderURL("tcp://localhost:61616");
        appender.setTopicBindingName("MyTopic");
        appender.setTopicConnectionFactoryBindingName("ConnectionFactory");
        appender.start();
        logger.addAppender((Appender)appender);
        for (int i = 0; i < 10000; ++i) {
            logger.debug("** Hello world. n=" + i);
        }
        long before = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            logger.debug("** Hello world. n=" + i);
        }
        long after = System.nanoTime();
        System.out.println("Time per logs for 10'000 logs: " + (after - before) / 10000L);
        StatusPrinter.print((StatusManager)lc.getStatusManager());
    }
}

