/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.server;

import ch.qos.logback.classic.net.server.InstrumentedServerSocketReceiver;
import ch.qos.logback.classic.net.server.RemoteAppenderClient;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.MockServerListener;
import ch.qos.logback.core.net.server.MockServerRunner;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.net.ServerSocket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketReceiverTest {
    private MockContext context = new MockContext();
    private MockServerRunner<RemoteAppenderClient> runner = new MockServerRunner();
    private MockServerListener<RemoteAppenderClient> listener = new MockServerListener();
    private ServerSocket serverSocket;
    private InstrumentedServerSocketReceiver receiver;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.receiver = new InstrumentedServerSocketReceiver(this.serverSocket, (ServerListener<RemoteAppenderClient>)this.listener, (ServerRunner<RemoteAppenderClient>)this.runner);
        this.receiver.setContext((Context)this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.serverSocket.close();
    }

    @Test
    public void testStartStop() throws Exception {
        this.receiver.start();
        Assert.assertTrue((boolean)this.runner.isContextInjected());
        Assert.assertTrue((boolean)this.runner.isRunning());
        Assert.assertSame(this.listener, (Object)this.receiver.getLastListener());
        this.receiver.stop();
        Assert.assertFalse((boolean)this.runner.isRunning());
    }

    @Test
    public void testStartWhenAlreadyStarted() throws Exception {
        this.receiver.start();
        this.receiver.start();
        Assert.assertEquals((long)1L, (long)this.runner.getStartCount());
    }

    @Test
    public void testStopThrowsException() throws Exception {
        this.receiver.start();
        Assert.assertTrue((boolean)this.receiver.isStarted());
        IOException ex = new IOException("test exception");
        this.runner.setStopException(ex);
        this.receiver.stop();
        Status status = this.context.getLastStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)(status instanceof ErrorStatus));
        Assert.assertTrue((boolean)status.getMessage().contains(ex.getMessage()));
        Assert.assertSame((Object)ex, (Object)status.getThrowable());
    }

    @Test
    public void testStopWhenNotStarted() throws Exception {
        this.receiver.stop();
        Assert.assertEquals((long)0L, (long)this.runner.getStartCount());
    }
}

