/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubLoggingEventVO
implements ILoggingEvent,
Serializable {
    private static final long serialVersionUID = -3385765861078946218L;
    private static final int NULL_ARGUMENT_ARRAY = -1;
    private static final String NULL_ARGUMENT_ARRAY_ELEMENT = "NULL_ARGUMENT_ARRAY_ELEMENT";
    public String threadName;
    public String loggerName;
    public LoggerContextVO loggerContextVO;
    public transient Level level;
    public String message;
    private transient String formattedMessage;
    public Object[] argumentArray;
    public IThrowableProxy throwableProxy;
    public StackTraceElement[] callerDataArray;
    public Marker marker;
    public Map<String, String> mdcPropertyMap;
    public long timeStamp;

    public String getThreadName() {
        return this.threadName;
    }

    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    public StackTraceElement[] getCallerData() {
        return this.callerDataArray;
    }

    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    public LoggerContextVO getContextLoggerRemoteView() {
        return this.loggerContextVO;
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    public Map<String, String> getMdc() {
        return this.mdcPropertyMap;
    }

    public void prepareForDeferredProcessing() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.level.levelInt);
        if (this.argumentArray != null) {
            int len = this.argumentArray.length;
            out.writeInt(len);
            for (int i = 0; i < this.argumentArray.length; ++i) {
                if (this.argumentArray[i] != null) {
                    out.writeObject(this.argumentArray[i].toString());
                    continue;
                }
                out.writeObject(NULL_ARGUMENT_ARRAY_ELEMENT);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int levelInt = in.readInt();
        this.level = Level.toLevel((int)levelInt);
        int argArrayLen = in.readInt();
        if (argArrayLen != -1) {
            this.argumentArray = new String[argArrayLen];
            for (int i = 0; i < argArrayLen; ++i) {
                Object val = in.readObject();
                if (NULL_ARGUMENT_ARRAY_ELEMENT.equals(val)) continue;
                this.argumentArray[i] = val;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.threadName == null ? 0 : this.threadName.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PubLoggingEventVO other = (PubLoggingEventVO)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.loggerName == null ? other.loggerName != null : !this.loggerName.equals(other.loggerName)) {
            return false;
        }
        if (this.threadName == null ? other.threadName != null : !this.threadName.equals(other.threadName)) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        if (this.marker == null ? other.marker != null : !this.marker.equals(other.marker)) {
            return false;
        }
        return !(this.mdcPropertyMap == null ? other.mdcPropertyMap != null : !((Object)this.mdcPropertyMap).equals(other.mdcPropertyMap));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timeStamp);
        sb.append(" ");
        sb.append(this.level);
        sb.append(" [");
        sb.append(this.threadName);
        sb.append("] ");
        sb.append(this.loggerName);
        sb.append(" - ");
        sb.append(this.getFormattedMessage());
        return sb.toString();
    }
}

