/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo.lru;

import ch.qos.logback.classic.turbo.lru.T_Entry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T_LRUCache<K> {
    int sequenceNumber;
    final int cacheSize;
    List<T_Entry<K>> cacheList = new LinkedList<T_Entry<K>>();

    public T_LRUCache(int size) {
        this.cacheSize = size;
    }

    public synchronized void put(K k) {
        ++this.sequenceNumber;
        T_Entry<K> te = this.getEntry(k);
        if (te != null) {
            te.sequenceNumber = this.sequenceNumber;
        } else {
            te = new T_Entry<K>(k, this.sequenceNumber);
            this.cacheList.add(te);
        }
        Collections.sort(this.cacheList);
        while (this.cacheList.size() > this.cacheSize) {
            this.cacheList.remove(0);
        }
    }

    public synchronized K get(K k) {
        T_Entry<K> te = this.getEntry(k);
        if (te == null) {
            return null;
        }
        te.sequenceNumber = ++this.sequenceNumber;
        Collections.sort(this.cacheList);
        return te.k;
    }

    public synchronized List<K> keyList() {
        ArrayList keyList = new ArrayList();
        for (T_Entry<K> e : this.cacheList) {
            keyList.add(e.k);
        }
        return keyList;
    }

    private T_Entry<K> getEntry(K k) {
        for (int i = 0; i < this.cacheList.size(); ++i) {
            T_Entry<K> te = this.cacheList.get(i);
            if (!te.k.equals(k)) continue;
            return te;
        }
        return null;
    }

    public void dump() {
        System.out.print("T:");
        for (T_Entry<K> te : this.cacheList) {
            System.out.print(te.k + ", ");
        }
        System.out.println();
    }
}

