/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.SdkStructuredJsonFactory;
import com.amazonaws.util.json.SdkStructuredPlainJsonFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;

@SdkProtectedApi
public class SdkJsonProtocolFactory {
    private static final SdkStructuredJsonFactory SDK_JSON_FACTORY = new SdkStructuredPlainJsonFactory();
    private static final SdkStructuredJsonFactory SDK_CBOR_FACTORY = new SdkStructuredPlainJsonFactory();
    @Deprecated
    public static final JsonFactory DEFAULT_FACTORY = SdkStructuredPlainJsonFactory.JSON_FACTORY;
    @Deprecated
    public static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.0";
    @Deprecated
    public static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> DEFAULT_SCALAR_UNMARSHALLERS = SdkStructuredPlainJsonFactory.JSON_SCALAR_UNMARSHALLERS;

    public static StructuredJsonGenerator createWriter(boolean supportsCbor, String protocolVersion) {
        return SdkJsonProtocolFactory.getSdkFactory(supportsCbor).createWriter(protocolVersion);
    }

    public static JsonResponseHandler createResponseHandler(Unmarshaller<?, JsonUnmarshallerContext> responseUnmarshaller, boolean supportsCbor) {
        return SdkJsonProtocolFactory.getSdkFactory(supportsCbor).createResponseHandler(responseUnmarshaller);
    }

    public static JsonErrorResponseHandlerV2 createErrorResponseHandler(List<JsonErrorUnmarshallerV2> errorUnmarshallers, boolean supportsCbor) {
        return SdkJsonProtocolFactory.getSdkFactory(supportsCbor).createErrorResponseHandler(errorUnmarshallers);
    }

    private static SdkStructuredJsonFactory getSdkFactory(boolean supportsCbor) {
        return SdkJsonProtocolFactory.isCborEnabled(supportsCbor) ? SDK_CBOR_FACTORY : SDK_JSON_FACTORY;
    }

    private static boolean isCborEnabled(boolean supportsCbor) {
        return supportsCbor && !SDKGlobalConfiguration.isCborDisabled();
    }
}

