/*
 * Decompiled with CFR 0.152.
 */
package com.gestalt.sip.utilities.message;

import com.gestalt.sip.utilities.message.ClientAuthenticationMethod;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class DigestClientAuthenticationMethod
implements ClientAuthenticationMethod {
    private static final Logger LOG = Logger.getLogger(DigestClientAuthenticationMethod.class);
    private String realm;
    private String userName;
    private String uri;
    private String nonce;
    private String password;
    private String method;
    private String cnonce;
    private MessageDigest messageDigest;
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] byteArray) {
        int pos = 0;
        char[] hexString = new char[byteArray.length * 2];
        for (int i = 0; i < byteArray.length; ++i) {
            hexString[pos++] = toHex[byteArray[i] >> 4 & 0xF];
            hexString[pos++] = toHex[byteArray[i] & 0xF];
        }
        return new String(hexString);
    }

    public void initialize(String realm, String userName, String uri, String nonce, String password, String method, String cnonce, String algorithm) throws Exception {
        if (realm == null) {
            throw new Exception("The realm parameter is null");
        }
        this.realm = realm;
        if (userName == null) {
            throw new Exception("The userName parameter is null");
        }
        this.userName = userName;
        if (uri == null) {
            throw new Exception("The uri parameter is null");
        }
        this.uri = uri;
        if (nonce == null) {
            throw new Exception("The nonce parameter is null");
        }
        this.nonce = nonce;
        if (password == null) {
            throw new Exception("The password parameter is null");
        }
        this.password = password;
        if (method == null) {
            throw new Exception("The method parameter is null");
        }
        this.method = method;
        this.cnonce = cnonce;
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, initialize(): ERROR: Digest algorithm does not exist.");
            throw new Exception("ERROR: Digest algorithm does not exist.", ex);
        }
    }

    public String generateResponse() {
        if (this.userName == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: no userName parameter");
            return null;
        }
        if (this.realm == null) {
            LOG.debug((Object)"DEBUG, DigestClientAuthenticationMethod, generateResponse(): ERROR: no realm parameter");
            return null;
        }
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(): Trying to generate a response for the user: " + this.userName + " , with " + "the realm: " + this.realm));
        if (this.password == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: no password parameter");
            return null;
        }
        if (this.method == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: no method parameter");
            return null;
        }
        if (this.uri == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: no uri parameter");
            return null;
        }
        if (this.nonce == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: no nonce parameter");
            return null;
        }
        if (this.messageDigest == null) {
            LOG.debug((Object)"DigestClientAuthenticationMethod, generateResponse(): ERROR: the algorithm is not set");
            return null;
        }
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), userName:" + this.userName + "!"));
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), realm:" + this.realm + "!"));
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), password:" + this.password + "!"));
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), uri:" + this.uri + "!"));
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), nonce:" + this.nonce + "!"));
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), method:" + this.method + "!"));
        String A1 = this.userName + ":" + this.realm + ":" + this.password;
        String A2 = this.method.toUpperCase() + ":" + this.uri;
        byte[] mdbytes = this.messageDigest.digest(A1.getBytes());
        String HA1 = DigestClientAuthenticationMethod.toHexString(mdbytes);
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), HA1:" + HA1 + "!"));
        mdbytes = this.messageDigest.digest(A2.getBytes());
        String HA2 = DigestClientAuthenticationMethod.toHexString(mdbytes);
        LOG.debug((Object)("DigestClientAuthenticationMethod, generateResponse(), HA2:" + HA2 + "!"));
        String KD = HA1 + ":" + this.nonce;
        if (this.cnonce != null) {
            KD = KD + ":" + this.cnonce;
        }
        KD = KD + ":" + HA2;
        mdbytes = this.messageDigest.digest(KD.getBytes());
        String response = DigestClientAuthenticationMethod.toHexString(mdbytes);
        LOG.debug((Object)("DigestClientAlgorithm, generateResponse(): response generated: " + response));
        return response;
    }
}

