/*
 * Decompiled with CFR 0.152.
 */
package com.gestalt.sip.utilities.message;

import com.gestalt.sip.utilities.message.DigestClientAuthenticationMethod;
import com.gestalt.sip.utilities.message.SipUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestGenerator {
    private static final Logger log = Logger.getLogger(RequestGenerator.class);
    private int cseq = Math.abs(new Random().nextInt());
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private AddressFactory addressFactory;
    private SipProvider sipProvider;
    private String sipURIUser;
    private String userURI;
    private SipURI userSipURI;
    private String contactIPAddress;
    private String signalingTransport;
    private String outboundProxyIPAddress;
    private int listeningPointPort;
    private int proxyPort;
    private boolean allowToHeaderPort = false;

    public RequestGenerator(MessageFactory messageFactory, HeaderFactory headerFactory, AddressFactory addressFactory, SipProvider sipProvider, String sipURIUser, String userURI, String contactIPAddress, String signalingTransport, String outboundProxyIPAddress, int listeningPointPort, int proxyPort) {
        this.messageFactory = messageFactory;
        this.headerFactory = headerFactory;
        this.addressFactory = addressFactory;
        this.sipProvider = sipProvider;
        this.sipURIUser = sipURIUser;
        this.userURI = userURI;
        this.contactIPAddress = contactIPAddress;
        this.signalingTransport = signalingTransport;
        this.outboundProxyIPAddress = outboundProxyIPAddress;
        this.listeningPointPort = listeningPointPort;
        this.proxyPort = proxyPort;
        try {
            this.userSipURI = this.addressFactory.createSipURI(this.sipURIUser, this.outboundProxyIPAddress);
        }
        catch (Exception e) {
            log.error((Object)"Exception constructing RequestGenerator!", (Throwable)e);
        }
    }

    private int getCseq() {
        return this.cseq++;
    }

    public ClientTransaction sendRequest(Request request, Dialog dialog, ClientTransaction clientTransaction, boolean useClientTransaction, boolean useSipProvider) throws Exception {
        log.debug((Object)"RequestGenerator.sendRequest()");
        if (useClientTransaction) {
            if (clientTransaction == null) {
                clientTransaction = this.sipProvider.getNewClientTransaction(request);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("about to send request:\n" + request));
            }
            if (dialog != null) {
                dialog.sendRequest(clientTransaction);
            } else {
                clientTransaction.sendRequest();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("request sent:\n" + request));
            }
            return clientTransaction;
        }
        if (useSipProvider) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("about to send request:\n" + request));
            }
            this.sipProvider.sendRequest(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("request sent:\n" + request));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("about to send request:\n" + request));
            }
            this.sipProvider.sendRequest(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("request sent:\n" + request));
            }
        }
        return null;
    }

    private SipURI generateURI(String callee, boolean addPort, boolean addTransport) throws Exception {
        String calleeURI = callee.trim();
        String user = SipUtil.getUserFromURI(calleeURI, 0);
        String host = SipUtil.getHostFromURI(calleeURI, 0);
        SipURI uri = this.generateURI(user, host, addPort, addTransport);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SipURI Generated: " + uri.toString()));
        }
        return uri;
    }

    private SipURI generateURI(String user, String host, boolean addPort, boolean addTransport) throws Exception {
        SipURI requestURI = this.addressFactory.createSipURI(user, host);
        if (addPort) {
            requestURI.setPort(this.proxyPort);
        }
        if (addTransport) {
            requestURI.setTransportParam(this.signalingTransport);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SipURI Generated: " + requestURI.toString()));
        }
        return requestURI;
    }

    private CallIdHeader generateCallId() {
        return this.sipProvider.getNewCallId();
    }

    private CSeqHeader generateCSeqHeader(int sequenceNumber, String requestName) throws Exception {
        return this.headerFactory.createCSeqHeader((long)sequenceNumber, requestName);
    }

    private FromHeader generateFromHeader(Address address, String tag) throws Exception {
        return this.headerFactory.createFromHeader(address, tag);
    }

    private FromHeader generateFromHeader(String user, String host, boolean addPort, boolean addTransport, String tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateFromHeader()");
        }
        SipURI fromURI = this.generateURI(user, host, addPort, addTransport);
        Address fromAddress = this.addressFactory.createAddress((URI)fromURI);
        return this.generateFromHeader(fromAddress, tag);
    }

    private ToHeader generateToHeader(Address address, String tag) throws Exception {
        return this.headerFactory.createToHeader(address, tag);
    }

    private ToHeader generateToHeader(String user, String host, boolean addPort, boolean addTransport, String tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateToHeader()");
        }
        SipURI toURI = this.generateURI(user, host, addPort, addTransport);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Address from URI: " + toURI));
        }
        Address toAddress = this.addressFactory.createAddress((URI)toURI);
        return this.generateToHeader(toAddress, tag);
    }

    private ViaHeader generateViaHeader(String ipAddress, int port, String transport, boolean generateBranchId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateViaHeader()");
        }
        ViaHeader viaHeader = this.headerFactory.createViaHeader(ipAddress, port, transport, null);
        if (generateBranchId) {
            viaHeader.setBranch(SipUtil.generateBranchId());
        }
        return viaHeader;
    }

    private List<ViaHeader> generateViaHeaderList(String ipAddress, int port, String transport, boolean generateBranchId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateViaHeaderList()");
        }
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        viaHeaders.add(this.generateViaHeader(ipAddress, port, transport, generateBranchId));
        return viaHeaders;
    }

    private MaxForwardsHeader generateMaxForwardsHeader(int maxForwards) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateMaxForwardsHeader()");
        }
        return this.headerFactory.createMaxForwardsHeader(maxForwards);
    }

    private ContactHeader generateContactHeader(String user, String host, boolean addPort, boolean addTransport) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.generateContactHeader()");
        }
        SipURI contactURI = this.generateURI(user, host, false, false);
        contactURI.setPort(this.listeningPointPort);
        Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
        return this.headerFactory.createContactHeader(contactAddress);
    }

    public Request createRequest(String requestName, SipURI requestURI, SipURI callerURI, SipURI calleeURI, boolean addProxyRouteHeader) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createRequest()");
        }
        CallIdHeader callIdHeader = this.generateCallId();
        CSeqHeader cSeqHeader = this.generateCSeqHeader(this.getCseq(), requestName);
        FromHeader fromHeader = this.generateFromHeader(callerURI.getUser(), callerURI.getHost(), false, false, SipUtil.getRandomId());
        String calleeHost = calleeURI.getHost();
        if (this.allowToHeaderPort && calleeHost.indexOf(":") == -1 && calleeHost.equals(callerURI.getHost())) {
            calleeHost = calleeHost + ":" + this.proxyPort;
        }
        ToHeader toHeader = this.generateToHeader(calleeURI.getUser(), calleeHost, false, false, null);
        List<ViaHeader> viaHeaders = this.generateViaHeaderList(this.contactIPAddress, this.listeningPointPort, this.signalingTransport, true);
        MaxForwardsHeader maxForwardsHeader = this.generateMaxForwardsHeader(70);
        Request request = this.messageFactory.createRequest((URI)requestURI, requestName, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
        ContactHeader contactHeader = this.generateContactHeader(callerURI.getUser(), this.contactIPAddress, false, false);
        request.addHeader((Header)contactHeader);
        if (addProxyRouteHeader) {
            SipURI routeURI = this.addressFactory.createSipURI(null, this.outboundProxyIPAddress + ":" + this.proxyPort);
            Address routeAddress = this.addressFactory.createAddress((URI)routeURI);
            RouteHeader routeHeader = this.headerFactory.createRouteHeader(routeAddress);
            request.addHeader((Header)routeHeader);
        }
        return request;
    }

    public Request createInviteRequest(SipURI caller, String callee, String sdp) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createInviteRequest()");
        }
        SipURI requestURI = this.generateURI(callee, true, false);
        Request invite = this.createRequest("INVITE", requestURI, caller, requestURI, true);
        if (sdp != null) {
            ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
            invite.setContent((Object)sdp, contentTypeHeader);
        }
        return invite;
    }

    public Request createSubscribeRequest(SipURI caller, String callee, int expires) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createSubscribeRequest()");
        }
        SipURI requestURI = this.generateURI(callee, true, true);
        Request subscribe = this.createRequest("SUBSCRIBE", requestURI, caller, requestURI, false);
        subscribe.addHeader((Header)this.headerFactory.createExpiresHeader(expires));
        subscribe.addHeader((Header)this.headerFactory.createEventHeader("presence"));
        subscribe.addHeader((Header)this.headerFactory.createAcceptHeader("application", "xpidf+xml"));
        subscribe.setContentLength(this.headerFactory.createContentLengthHeader(0));
        return subscribe;
    }

    public Request createUnsubscribeRequest(SipURI caller, String callee) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createUnsubscribeRequest()");
        }
        SipURI requestURI = this.generateURI(callee, true, true);
        Request subscribe = this.createRequest("SUBSCRIBE", requestURI, caller, requestURI, false);
        subscribe.setHeader((Header)this.headerFactory.createExpiresHeader(0));
        return subscribe;
    }

    public Request createRegisterRequest(SipURI caller, int expires) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createRegisterRequest()");
        }
        SipURI requestURI = this.generateURI("@" + this.outboundProxyIPAddress, true, false);
        Request request = this.createRequest("REGISTER", requestURI, caller, caller, false);
        request.addHeader((Header)this.headerFactory.createExpiresHeader(expires));
        request.addHeader((Header)this.headerFactory.createEventHeader("registration"));
        request.setContentLength(this.headerFactory.createContentLengthHeader(0));
        return request;
    }

    public Request createRequestWithAuthentication(String username, String password, String proxyhost, Response response, Request newRequest) {
        Header authHeader = this.createAuthorizationHeader(username, password, proxyhost, response);
        if (authHeader == null) {
            log.debug((Object)"IMUserAgent, processResponse(), Proxy-Authorization \" +\n header is null, the request is not resent");
        } else {
            newRequest.setHeader(authHeader);
        }
        return newRequest;
    }

    private Header createAuthorizationHeader(String username, String password, String proxyhost, Response response) {
        try {
            ProxyAuthenticateHeader authenticateHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate");
            CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
            String cnonce = null;
            String uri = "sip:" + proxyhost + ":" + this.proxyPort;
            String method = cseqHeader.getMethod();
            String nonce = null;
            String realm = null;
            String qop = null;
            if (authenticateHeader == null) {
                WWWAuthenticateHeader wwwAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
                nonce = wwwAuthenticateHeader.getNonce();
                realm = wwwAuthenticateHeader.getRealm();
                if (realm == null) {
                    log.debug((Object)"AuthenticationProcess, getProxyAuthorizationHeader(), ERROR: the realm is not part of the 401 response!");
                    return null;
                }
                cnonce = wwwAuthenticateHeader.getParameter("cnonce");
                qop = wwwAuthenticateHeader.getParameter("qop");
            } else {
                nonce = authenticateHeader.getNonce();
                realm = authenticateHeader.getRealm();
                if (realm == null) {
                    log.debug((Object)"AuthenticationProcess, getProxyAuthorizationHeader(), ERROR: the realm is not part of the 407 response!");
                    return null;
                }
                cnonce = authenticateHeader.getParameter("cnonce");
                qop = authenticateHeader.getParameter("qop");
            }
            DigestClientAuthenticationMethod digest = new DigestClientAuthenticationMethod();
            digest.initialize(realm, username, uri, nonce, password, method, cnonce, "MD5");
            ProxyAuthorizationHeader header = this.headerFactory.createProxyAuthorizationHeader("Digest");
            header.setParameter("username", username);
            header.setParameter("realm", realm);
            header.setParameter("uri", uri);
            header.setParameter("algorithm", "MD5");
            header.setParameter("opaque", "");
            header.setParameter("nonce", nonce);
            header.setParameter("response", digest.generateResponse());
            if (qop != null) {
                header.setParameter("qop", qop);
            }
            return header;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Request createUnregisterRequest(SipURI caller) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createUnregisterRequest()");
        }
        SipURI requestURI = this.generateURI("@" + this.outboundProxyIPAddress, true, false);
        Request request = this.createRequest("REGISTER", requestURI, caller, caller, false);
        request.setHeader((Header)this.headerFactory.createExpiresHeader(0));
        request.setContentLength(this.headerFactory.createContentLengthHeader(0));
        return request;
    }

    public Request createMessageRequest(SipURI caller, String callee, String message) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createMessageRequest()");
        }
        SipURI requestURI = this.generateURI(callee, true, true);
        Request request = this.createRequest("MESSAGE", requestURI, caller, requestURI, false);
        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("text", "plain;charset=UTF-8");
        request.setContent((Object)message, contentTypeHeader);
        return request;
    }

    public Request createByeRequest(Dialog dialog, String caller, String callee) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createByeRequest()");
        }
        boolean originatedHere = caller.equals(this.userURI);
        Request request = dialog.createRequest("BYE");
        ContactHeader contactHeader = this.generateContactHeader(SipUtil.getUserFromURI(callee, 0), this.contactIPAddress, false, false);
        request.setHeader((Header)contactHeader);
        FromHeader newFromHeader = (FromHeader)request.getHeader("From");
        newFromHeader.setTag(dialog.getLocalTag());
        newFromHeader.setAddress(dialog.getLocalParty());
        ToHeader newToHeader = (ToHeader)request.getHeader("To");
        newToHeader.setTag(dialog.getRemoteTag());
        newToHeader.setAddress(dialog.getRemoteParty());
        if (originatedHere) {
            request.setRequestURI((URI)this.generateURI(callee, true, false));
        } else {
            request.setRequestURI((URI)this.generateURI(caller, true, false));
        }
        ViaHeader viaHeader = this.generateViaHeader(this.contactIPAddress, this.listeningPointPort, this.signalingTransport, true);
        request.addHeader((Header)viaHeader);
        return request;
    }

    public Request createCancelRequest(ClientTransaction clientTransaction) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createByeRequest()");
        }
        Request cancelRequest = clientTransaction.createCancel();
        return cancelRequest;
    }

    public Request createSuccessfulAckRequst(ClientTransaction clientTransaction, Response response) throws Exception {
        RouteHeader firstRouteHeader;
        Address firstRouteHeaderAddress;
        SipURI firstRouteHeaderUri;
        List<RouteHeader> routeHeaderList;
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestGenerator.createSuccessfulAckRequest()");
        }
        Dialog dialog = clientTransaction.getDialog();
        SipURI toURI = (SipURI)((ContactHeader)response.getHeader("Contact")).getAddress().getURI();
        SipURI requestURI = this.generateURI(toURI.getUser(), toURI.getHost() + ":" + toURI.getPort(), false, false);
        CSeqHeader cSeq = this.generateCSeqHeader(((CSeqHeader)clientTransaction.getRequest().getHeader("CSeq")).getSequenceNumber(), "ACK");
        FromHeader fromHeader = this.generateFromHeader(dialog.getLocalParty(), null);
        ToHeader toHeader = this.generateToHeader(dialog.getRemoteParty(), null);
        MaxForwardsHeader maxForwardsHeader = this.generateMaxForwardsHeader(70);
        ViaHeader viaHeader = this.generateViaHeader(this.contactIPAddress, this.listeningPointPort, this.signalingTransport, true);
        ArrayList<ViaHeader> viaHeaderList = new ArrayList<ViaHeader>();
        viaHeaderList.add(viaHeader);
        Request request = this.messageFactory.createRequest((URI)requestURI, "ACK", dialog.getCallId(), cSeq, fromHeader, toHeader, viaHeaderList, maxForwardsHeader);
        this.setHeaderTags(request, dialog);
        if (null == request.getHeader("Route")) {
            request.removeHeader("Route");
            if (dialog.getRouteSet() != null) {
                Iterator itr = dialog.getRouteSet();
                while (itr.hasNext()) {
                    Address routeAddress = (Address)itr.next();
                    RouteHeader routeHeader = this.headerFactory.createRouteHeader(routeAddress);
                    routeHeader.setAddress(routeAddress);
                    ListIterator itr1 = response.getHeaders("Record-Route");
                    while (itr1.hasNext()) {
                        RecordRouteHeader recordRouteHeader = (RecordRouteHeader)itr1.next();
                        Address recordRouteHeaderAddress = recordRouteHeader.getAddress();
                        if (!routeAddress.getURI().equals(recordRouteHeaderAddress.getURI())) continue;
                        Iterator itr2 = recordRouteHeader.getParameterNames();
                        while (itr2.hasNext()) {
                            String name = (String)itr2.next();
                            routeHeader.setParameter(name, recordRouteHeader.getParameter(name));
                        }
                    }
                    request.addHeader((Header)routeHeader);
                }
            }
        }
        if (null != (routeHeaderList = RequestGenerator.getRouteHeaderList(request)) && !routeHeaderList.isEmpty() && !(firstRouteHeaderUri = (SipURI)(firstRouteHeaderAddress = (firstRouteHeader = routeHeaderList.get(0)).getAddress()).getURI()).hasLrParam()) {
            ((SipURI)dialog.getRemoteTarget().getURI()).removeParameter("transport");
            RouteHeader newRouteHeader = this.headerFactory.createRouteHeader(dialog.getRemoteTarget());
            newRouteHeader.setAddress(dialog.getRemoteTarget());
            newRouteHeader.removeParameter("transport");
            routeHeaderList.add(newRouteHeader);
            RequestGenerator.setRouteHeaderList(request, routeHeaderList);
        }
        ContactHeader contactHeader = this.generateContactHeader(this.sipURIUser, this.contactIPAddress, false, false);
        request.addHeader((Header)contactHeader);
        ContentLengthHeader contentHeader = this.headerFactory.createContentLengthHeader(0);
        request.addHeader((Header)contentHeader);
        return request;
    }

    private void setHeaderTags(Request request, Dialog dialog) throws Exception {
        FromHeader fromHeader = (FromHeader)request.getHeader("From");
        fromHeader.setTag(dialog.getLocalTag());
        request.setHeader((Header)fromHeader);
        ToHeader toHeader = (ToHeader)request.getHeader("To");
        toHeader.setTag(dialog.getRemoteTag());
        request.setHeader((Header)toHeader);
    }

    public static List<RecordRouteHeader> getRecordRouteHeaderList(Request request) {
        ListIterator recordRouteHeaderIterator = request.getHeaders("Record-Route");
        ArrayList<RecordRouteHeader> recordRouteHeaderList = new ArrayList<RecordRouteHeader>();
        while (recordRouteHeaderIterator.hasNext()) {
            recordRouteHeaderList.add((RecordRouteHeader)recordRouteHeaderIterator.next());
        }
        return recordRouteHeaderList;
    }

    public static List<RouteHeader> getRouteHeaderList(Request request) {
        ListIterator routeHeaderIterator = request.getHeaders("Route");
        ArrayList<RouteHeader> routeHeaderList = new ArrayList<RouteHeader>();
        while (routeHeaderIterator.hasNext()) {
            routeHeaderList.add((RouteHeader)routeHeaderIterator.next());
        }
        return routeHeaderList;
    }

    public static void setRouteHeaderList(Request request, List<RouteHeader> routeHeaderList) {
        for (RouteHeader rHeader : routeHeaderList) {
            request.addHeader((Header)rHeader);
        }
    }

    public SipProvider getSipProvider() {
        return this.sipProvider;
    }

    public SipURI getUserSipURI() {
        return this.userSipURI;
    }

    public String getUserURI() {
        return this.userURI;
    }

    public boolean isAllowToHeaderPort() {
        return this.allowToHeaderPort;
    }

    public void allowToHeaderPort(boolean usePort) {
        this.allowToHeaderPort = usePort;
    }
}

