/*
 * Decompiled with CFR 0.152.
 */
package com.gestalt.sip.utilities.message;

import com.gestalt.sip.utilities.message.RequestGenerator;
import com.gestalt.sip.utilities.message.SipUtil;
import java.util.List;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallInfoHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseGenerator {
    private static final Logger log = Logger.getLogger(ResponseGenerator.class);
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private AddressFactory addressFactory;
    private String sipURIUser;
    private String httpBusyMessage;
    private String contactIPAddress;
    private int listeningPointPort;

    public ResponseGenerator(MessageFactory messageFactory, HeaderFactory headerFactory, AddressFactory addressFactory, String sipURIUser, String httpBusyMessage, String contactIPAddress, int listeningPointPort) {
        this.messageFactory = messageFactory;
        this.headerFactory = headerFactory;
        this.addressFactory = addressFactory;
        this.sipURIUser = sipURIUser;
        this.httpBusyMessage = httpBusyMessage;
        this.contactIPAddress = contactIPAddress;
        this.listeningPointPort = listeningPointPort;
    }

    public void sendResponse(Response response, ServerTransaction serverTransaction) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending response:\n" + response));
        }
        serverTransaction.sendResponse(response);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response sent:\n" + response));
        }
    }

    public Response generateResponse(int responseType, Request request, boolean generateTag, boolean useRequestTagIfFound, String defaultTag) throws Exception {
        Response response = this.messageFactory.createResponse(responseType, request);
        SipURI contactURI = this.addressFactory.createSipURI(this.sipURIUser, this.contactIPAddress);
        ContactHeader contactHeader = this.headerFactory.createContactHeader(this.addressFactory.createAddress((URI)contactURI));
        contactURI.setPort(this.listeningPointPort);
        response.setHeader((Header)contactHeader);
        List<RecordRouteHeader> recordRouteHeaders = RequestGenerator.getRecordRouteHeaderList(request);
        if (recordRouteHeaders != null && !recordRouteHeaders.isEmpty()) {
            ResponseGenerator.setRecordRouteHeaders(response, recordRouteHeaders);
        }
        if (generateTag) {
            ((ToHeader)response.getHeader("To")).setTag(SipUtil.getRandomId());
        } else if (useRequestTagIfFound) {
            ((ToHeader)response.getHeader("To")).setTag(((ToHeader)request.getHeader("To")).getTag());
        } else {
            ((ToHeader)response.getHeader("To")).setTag(defaultTag);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response ToHeader: " + response.getHeader("To").toString()));
        }
        return response;
    }

    public Response generateBusyResponse(Request request) throws Exception {
        Response busyHere = this.generateResponse(486, request, false, false, null);
        if (this.httpBusyMessage != null) {
            CallInfoHeader callInfoHeader = this.headerFactory.createCallInfoHeader(this.addressFactory.createURI(this.httpBusyMessage));
            busyHere.addHeader((Header)callInfoHeader);
        }
        return busyHere;
    }

    public Response generateRequestTerminatedResponse(Request request) throws Exception {
        return this.generateResponse(487, request, true, false, SipUtil.getRandomId());
    }

    public Response generateTryingResponse(Request request) throws Exception {
        return this.generateResponse(100, request, true, false, null);
    }

    public Response generateRingingResponse(Request invite, Response trying) throws Exception {
        return this.generateResponse(180, invite, false, false, ((ToHeader)trying.getHeader("To")).getTag());
    }

    public Response generateRingingResponse(Request invite) throws Exception {
        return this.generateResponse(180, invite, false, true, SipUtil.getRandomId());
    }

    public Response generateByeOkResponse(Request bye) throws Exception {
        return this.generateResponse(200, bye, true, false, SipUtil.getRandomId());
    }

    public Response generateCancelOkResponse(Request cancel) throws Exception {
        return this.generateResponse(200, cancel, false, false, null);
    }

    public Response generateMessageOkResponse(Request message) throws Exception {
        return this.generateResponse(200, message, false, true, SipUtil.getRandomId());
    }

    public Response generateMessageNotAcceptableResponse(Request message) throws Exception {
        return this.generateResponse(406, message, false, false, null);
    }

    public Response generateNotifyOkResponse(Request notify) throws Exception {
        return this.generateResponse(200, notify, false, true, SipUtil.getRandomId());
    }

    public Response generateInviteTemporarilyUnavailable(Request invite) throws Exception {
        return this.generateResponse(480, invite, true, false, SipUtil.getRandomId());
    }

    public Response generateInviteOkResponse(Request request, Dialog dialog, Object sdp) throws Exception {
        String localTag;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ResponseGenerator.generateInviteOkResponse()");
        }
        if ((localTag = dialog.getLocalTag()) == null || localTag.equalsIgnoreCase("")) {
            localTag = SipUtil.getRandomId();
        }
        Response ok = this.generateResponse(200, request, false, false, localTag);
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
        if (contentTypeHeader != null && sdp != null) {
            ok.setContent(sdp, contentTypeHeader);
        } else {
            ok.setHeader((Header)contentTypeHeader);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Generated OK Response: \n");
            log.debug((Object)ok);
        }
        return ok;
    }

    public static void setRecordRouteHeaders(Response response, List<RecordRouteHeader> recordRouteHeaders) {
        for (RecordRouteHeader rrHeader : recordRouteHeaders) {
            response.addHeader((Header)rrHeader);
        }
    }
}

