/*
 * Decompiled with CFR 0.152.
 */
package com.gestalt.sip.utilities.message;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;

public class SipUtil {
    private static final Logger log = Logger.getLogger(SipUtil.class);
    public static final String BRANCH_MAGIC_COOKIE = "z9hG4bK";
    public static final String SIP_PROTOCOL = "sip";
    public static final String COLON = ":";
    public static final String FORWARD_SLASH = "/";
    public static final String SEMI_COLON = ";";
    public static final String AT = "@";
    public static final String EMPTY = "";
    public static final String SIP_PROTOCOL_HEADER = "sip:";
    private static final String MESSAGE_DIGEST = "MD5";
    private static final String BRANCH_PREFIX = "z9hG4bK-independent-";
    private static MessageDigest messageDigest;
    private static final char[] toHex;

    public static String generateBranchId() {
        String b = SipUtil.getRandomId() + System.currentTimeMillis();
        try {
            if (messageDigest == null) {
                messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            }
            byte[] bid = messageDigest.digest(b.getBytes());
            return BRANCH_PREFIX + SipUtil.toHexString(bid);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    public static String getNewCallId(String userAtHost) {
        return SipUtil.getRandomId().concat(SipUtil.getRandomId()).concat(COLON).concat(userAtHost);
    }

    public static String prepareURI(String contactURI) {
        if (!contactURI.startsWith(SIP_PROTOCOL_HEADER)) {
            contactURI = SipUtil.buildSipUserAtHost(contactURI);
        }
        return contactURI;
    }

    public static String buildSipUserAtHost(SipURI uri) {
        return SipUtil.buildSipUserAtHost(SipUtil.buildUserAtHost(uri));
    }

    public static String buildSipUserAtHost(String contactURI) {
        return SIP_PROTOCOL_HEADER + contactURI;
    }

    public static String buildSipUserAtHost(URI uri) {
        return SIP_PROTOCOL_HEADER + SipUtil.buildUserAtHost(uri);
    }

    public static String buildUserAtHost(SipURI uri) {
        return SipUtil.buildUserAtHost(uri.getUser(), uri.getHost());
    }

    public static String buildUserAtHost(URI uri) {
        return SipUtil.buildUserAtHost(SipUtil.getUserFromURI(uri), SipUtil.getHostFromURI(uri));
    }

    public static String getUserFromURI(URI uri) {
        String uriString = uri.toString();
        uriString = uriString.substring(1, uriString.length() - 1);
        int firstColonIndex = uriString.indexOf(COLON);
        int atIndex = uriString.indexOf(AT);
        String user = EMPTY;
        user = firstColonIndex > -1 && firstColonIndex < atIndex ? uriString.substring(firstColonIndex + 1, atIndex) : uriString.substring(0, atIndex);
        return user;
    }

    public static String getHostFromURI(URI uri) {
        String uriString = uri.toString();
        uriString = uriString.substring(1, uriString.length());
        int lastColonIndex = uriString.lastIndexOf(COLON);
        int atIndex = uriString.indexOf(AT);
        String host = EMPTY;
        host = lastColonIndex > atIndex ? uriString.substring(atIndex + 1, lastColonIndex) : uriString.substring(atIndex + 1);
        return host;
    }

    public static String buildUserAtHost(String user, String host) {
        return user + AT + host;
    }

    public static URI getURIFromHeader(Request request, String headerType) {
        Address address = SipUtil.getAddressFromHeader(request, headerType);
        return address.getURI();
    }

    public static URI getURIFromHeader(Response response, String headerType) {
        Address address = SipUtil.getAddressFromHeader(response, headerType);
        return address.getURI();
    }

    public static Address getAddressFromHeader(Request request, String headerType) {
        Header header = request.getHeader(headerType);
        Address address = null;
        if (headerType.equals("From")) {
            FromHeader fromHeader = (FromHeader)header;
            address = fromHeader.getAddress();
        } else if (headerType.equals("To")) {
            ToHeader toHeader = (ToHeader)header;
            address = toHeader.getAddress();
        }
        return address;
    }

    public static Address getAddressFromHeader(Response response, String headerType) {
        Header header = response.getHeader(headerType);
        Address address = null;
        if (headerType.equals("To")) {
            ToHeader toHeader = (ToHeader)header;
            address = toHeader.getAddress();
        }
        return address;
    }

    public static String getUserFromURI(String uri, int terminalOffset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SipUtil.getUserFromURI() - uri: " + uri.toString()));
        }
        return uri.substring(0, uri.indexOf(AT) + terminalOffset);
    }

    public static String getHostFromURI(String uri, int terminalOffset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SipUtil.getHostFromURI() - uri: " + uri.toString()));
        }
        return uri.substring(uri.indexOf(AT) + 1, uri.length() + terminalOffset);
    }

    public static boolean isNull(String string) {
        return string == null || EMPTY.equals(string);
    }

    public static boolean matchesContent(ContentTypeHeader header, String contentType, String contentSubtype) {
        if (header == null) {
            return false;
        }
        String type = header.getContentType();
        if (contentType == null) {
            type = null;
        }
        String subtype = header.getContentSubType();
        return type.equals(contentType) && subtype.equals(contentSubtype);
    }

    public static String getRandomId() {
        return SipUtil.getRandomId(10000);
    }

    public static String getRandomId(int seed) {
        return new Integer((int)(Math.random() * (double)seed)).toString();
    }

    public static String getLocalHost() {
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostName;
    }

    static {
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

