package gwt.material.design.client.constants;

/*
 * #%L
 * GwtMaterial
 * %%
 * Copyright (C) 2015 GwtMaterialDesign
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import gwt.material.design.client.base.helper.EnumHelper;

/**
 * @author Ben Dol
 */
public enum IconType implements CssType {
    DEFAULT(""),
    ROTATION_3D("3d_rotation"),
    ACCESSIBILITY("accessibility"),
    ACCOUNT_BALANCE_WALLET("account_balance_wallet"),
    ACCOUNT_BALANCE("account_balance"),
    ACCOUNT_BOX("account_box"),
    ACCOUNT_CHILD("account_child"),
    ACCOUNT_CIRCLE("account_circle"),
    ADD_SHOPPING_CART("add_shopping_cart"),
    ALARM_ADD("alarm_add"),
    ALARM_OFF("alarm_off"),
    ALARM_ON("alarm_on"),
    ALARM("alarm"),
    ANDROID("android"),
    ANNOUNCEMENT("announcement"),
    ASPECT_RATIO("aspect_ratio"),
    ASSESSMENT("assessment"),
    ASSIGNMENT_IND("assignment_ind"),
    ASSIGNMENT_LATE("assignment_late"),
    ASSIGNMENT_RETURN("assignment_return"),
    ASSIGNMENT_RETURNED("assignment_returned"),
    ASSIGNMENT_TURNED_IN("assignment_turned_in"),
    ASSIGNMENT("assignment"),
    AUTORENEW("autorenew"),
    BACKUP("backup"),
    BOOK("book"),
    BOOKMARK_OUTLINE("bookmark_outline"),
    BOOKMARK("bookmark"),
    BUG_REPORT("bug_report"),
    CACHED("cached"),
    CHECK_CIRCLE("check_circle"),
    CLASS("class"),
    CREDIT_CARD("credit_card"),
    DASHBOARD("dashboard"),
    DELETE("delete"),
    DESCRIPTION("description"),
    DNS("dns"),
    DONE_ALL("done_all"),
    DONE("done"),
    EVENT("event"),
    EXIT_TO_APP("exit_to_app"),
    EXPLORE("explore"),
    EXTENSION("extension"),
    FACE("face"),
    UNLOCK("unlock"),
    FAVORITE_OUTLINE("favorite_outline"),
    FAVORITE("favorite"),
    FIND_IN_PAGE("find_in_page"),
    FIND_REPLACE("find_replace"),
    FLIP_TO_BACK("flip_to_back"),
    FLIP_TO_FRONT("flip_to_front"),
    GET_APP("get_app"),
    GRADE("grade"),
    GROUP_WORK("group_work"),
    HELP("help"),
    HIGHLIGHT_REMOVE("highlight_remove"),
    HISTORY("history"),
    HOME("home"),
    HTTPS("https"),
    INFO_OUTLINE("info_outline"),
    INFO("info"),
    INPUT("input"),
    INVERT_COLORS("invert_colors"),
    LABEL_OUTLINE("label_outline"),
    LABEL("label"),
    LANGUAGE("language"),
    LAUNCH("launch"),
    LIST("list"),
    LOCK_OPEN("lock_open"),
    LOCK_OUTLINE("lock_outline"),
    LOCK("lock"),
    LOYALTY("loyalty"),
    MARKUNREAD_MAILBOX("markunread_mailbox"),
    NOTE_ADD("note_add"),
    OPEN_IN_BROWSER("open_in_browser"),
    OPEN_IN_NEW("open_in_new"),
    OPEN_WITH("open_with"),
    PAGEVIEW("pageview"),
    PAYMENT("payment"),
    PERM_CAMERA_MIC("perm_camera_mic"),
    PERM_CONTACT_CAL("perm_contact_cal"),
    PERM_DATA_SETTING("perm_data_setting"),
    PERM_DEVICE_INFO("perm_device_info"),
    PERM_IDENTITY("perm_identity"),
    PERM_MEDIA("perm_media"),
    PERM_PHONE_MSG("perm_phone_msg"),
    PERM_SCAN_WIFI("perm_scan_wifi"),
    PICTURE_IN_PICTURE("picture_in_picture"),
    POLYMER("polymer"),
    PRINT("print"),
    QUERY_BUILDER("query_builder"),
    QUESTION_ANSWER("question_answer"),
    RECEIPT("receipt"),
    REDEEM("redeem"),
    REORDER("reorder"),
    REPORT_PROBLEM("report_problem"),
    RESTORE("restore"),
    ROOM("room"),
    SCHEDULE("schedule"),
    SEARCH("search"),
    SETTINGS_APPLICATIONS("settings_applications"),
    SETTINGS_BACKUP_RESTORE("settings_backup_restore"),
    SETTINGS_BLUETOOTH("settings_bluetooth"),
    SETTINGS_CELL("settings_cell"),
    SETTINGS_DISPLAY("settings_display"),
    SETTINGS_ETHERNET("settings_ethernet"),
    SETTINGS_INPUT_ANTENNA("settings_input_antenna"),
    SETTINGS_INPUT_COMPONENT("settings_input_component"),
    SETTINGS_INPUT_COMPOSITE("settings_input_composite"),
    SETTINGS_INPUT_HDMI("settings_input_hdmi"),
    SETTINGS_INPUT_SVIDEO("settings_input_svideo"),
    SETTINGS_OVERSCAN("settings_overscan"),
    SETTINGS_PHONE("settings_phone"),
    SETTINGS_POWER("settings_power"),
    SETTINGS_REMOTE("settings_remote"),
    SETTINGS_VOICE("settings_voice"),
    SETTINGS("settings"),
    SHOP_TWO("shop_two"),
    SHOP("shop"),
    SHOPPING_BASKET("shopping_basket"),
    SHOPPING_CART("shopping_cart"),
    SPEAKER_NOTES("speaker_notes"),
    SPELLCHECK("spellcheck"),
    STAR_RATE("star_rate"),
    STARS("stars"),
    STORE("store"),
    SUBJECT("subject"),
    SUPERVISOR_ACCOUNT("supervisor_account"),
    SWAP_HORIZ("swap_horiz"),
    SWAP_VERT_CIRCLE("swap_vert_circle"),
    SWAP_VERT("swap_vert"),
    SYSTEM_UPDATE_TV("system_update_tv"),
    TAB_UNSELECTED("tab_unselected"),
    TAB("tab"),
    THEATERS("theaters"),
    THUMB_DOWN("thumb_down"),
    THUMB_UP("thumb_up"),
    THUMBS_UP_DOWN("thumbs_up_down"),
    TOC("toc"),
    TODAY("today"),
    TRACK_CHANGES("track_changes"),
    TRANSLATE("translate"),
    TRENDING_DOWN("trending_down"),
    TRENDING_NEUTRAL("trending_neutral"),
    TRENDING_UP("trending_up"),
    TURNED_IN_NOT("turned_in_not"),
    TURNED_IN("turned_in"),
    VERIFIED_USER("verified_user"),
    VIEW_AGENDA("view_agenda"),
    VIEW_ARRAY("view_array"),
    VIEW_CAROUSEL("view_carousel"),
    VIEW_COLUMN("view_column"),
    VIEW_DAY("view_day"),
    VIEW_HEADLINE("view_headline"),
    VIEW_LIST("view_list"),
    VIEW_MODULE("view_module"),
    VIEW_QUILT("view_quilt"),
    VIEW_STREAM("view_stream"),
    VIEW_WEEK("view_week"),
    VISIBILITY_OFF("visibility_off"),
    VISIBILITY("visibility"),
    WALLET_GIFTCARD("wallet_giftcard"),
    WALLET_MEMBERSHIP("wallet_membership"),
    WALLET_TRAVEL("wallet_travel"),
    WORK("work"),
    ERROR("error"),
    WARNING("warning"),
    ALBUM("album"),
    CLOSED_CAPTION("closed_caption"),
    EQUALIZER("equalizer"),
    EXPLICIT("explicit"),
    FAST_FORWARD("fast_forward"),
    FAST_REWIND("fast_rewind"),
    GAMES("games"),
    HEARING("hearing"),
    HIGH_QUALITY("high_quality"),
    LOOP("loop"),
    MIC_NONE("mic_none"),
    MIC_OFF("mic_off"),
    MIC("mic"),
    MOVIE("movie"),
    MY_LIBRARY_ADD("my_library_add"),
    MY_LIBRARY_BOOKS("my_library_books"),
    MY_LIBRARY_MUSIC("my_library_music"),
    NEW_RELEASES("new_releases"),
    NOT_INTERESTED("not_interested"),
    PAUSE_CIRCLE_FILL("pause_circle_fill"),
    PAUSE_CIRCLE_OUTLINE("pause_circle_outline"),
    PAUSE("pause"),
    PLAY_ARROW("play_arrow"),
    PLAY_CIRCLE_FILL("play_circle_fill"),
    PLAY_CIRCLE_OUTLINE("play_circle_outline"),
    PLAY_SHOPPING_BAG("play_shopping_bag"),
    PLAYLIST_ADD("playlist_add"),
    QUEUE_MUSIC("queue_music"),
    QUEUE("queue"),
    RADIO("radio"),
    RECENT_ACTORS("recent_actors"),
    REPEAT_ONE("repeat_one"),
    REPEAT("repeat"),
    REPLAY("replay"),
    SHUFFLE("shuffle"),
    SKIP_NEXT("skip_next"),
    SKIP_PREVIOUS("skip_previous"),
    SNOOZE("snooze"),
    STOP("stop"),
    SUBTITLES("subtitles"),
    SURROUND_SOUND("surround_sound"),
    VIDEO_COLLECTION("video_collection"),
    VIDEOCAM_OFF("videocam_off"),
    VIDEOCAM("videocam"),
    VOLUME_DOWN("volume_down"),
    VOLUME_MUTE("volume_mute"),
    VOLUME_OFF("volume_off"),
    VOLUME_UP("volume_up"),
    WEB("web"),
    BUSINESS("business"),
    CALL_END("call_end"),
    CALL_MADE("call_made"),
    CALL_MERGE("call_merge"),
    CALL_MISSED("call_missed"),
    CALL_RECEIVED("call_received"),
    CALL_SPLIT("call_split"),
    CALL("call"),
    CHAT("chat"),
    CLEAR_ALL("clear_all"),
    COMMENT("comment"),
    CONTACTS("contacts"),
    DIALER_SIP("dialer_sip"),
    DIALPAD("dialpad"),
    DND_ON("dnd_on"),
    EMAIL("email"),
    FORUM("forum"),
    IMPORT_EXPORT("import_export"),
    INVERT_COLORS_OFF("invert_colors_off"),
    INVERT_COLORS_ON("invert_colors_on"),
    LIVE_HELP("live_help"),
    LOCATION_OFF("location_off"),
    LOCATION_ON("location_on"),
    MESSAGE("message"),
    MESSENGER("messenger"),
    NO_SIM("no_sim"),
    PHONE("phone"),
    PORTABLE_WIFI_OFF("portable_wifi_off"),
    QUICK_CONTACTS_DIALER("quick_contacts_dialer"),
    QUICK_CONTACTS_MAIL("quick_contacts_mail"),
    RING_VOLUME("ring_volume"),
    STAY_CURRENT_LANDSCAPE("stay_current_landscape"),
    STAY_CURRENT_PORTRAIT("stay_current_portrait"),
    STAY_PRIMARY_LANDSCAPE("stay_primary_landscape"),
    STAY_PRIMARY_PORTRAIT("stay_primary_portrait"),
    SWAP_CALLS("swap_calls"),
    TEXTSMS("textsms"),
    VOICEMAIL("voicemail"),
    VPN_KEY("vpn_key"),
    ADD_BOX("add_box"),
    ADD_CIRCLE_OUTLINE("add_circle_outline"),
    ADD_CIRCLE("add_circle"),
    ADD("add"),
    ARCHIVE("archive"),
    BACKSPACE("backspace"),
    BLOCK("block"),
    CLEAR("clear"),
    CONTENT_COPY("content_copy"),
    CONTENT_CUT("content_cut"),
    CONTENT_PASTE("content_paste"),
    CREATE("create"),
    DRAFTS("drafts"),
    FILTER_LIST("filter_list"),
    FLAG("flag"),
    FORWARD("forward"),
    GESTURE("gesture"),
    INBOX("inbox"),
    LINK("link"),
    MAIL("mail"),
    MARKUNREAD("markunread"),
    REDO("redo"),
    REMOVE_CIRCLE_OUTLINE("remove_circle_outline"),
    REMOVE_CIRCLE("remove_circle"),
    REMOVE("remove"),
    REPLY_ALL("reply_all"),
    REPLY("reply"),
    REPORT("report"),
    SAVE("save"),
    SELECT_ALL("select_all"),
    SEND("send"),
    SORT("sort"),
    TEXT_FORMAT("text_format"),
    UNDO("undo"),
    ATTACH_FILE("attach_file"),
    ATTACH_MONEY("attach_money"),
    BORDER_ALL("border_all"),
    BORDER_BOTTOM("border_bottom"),
    BORDER_CLEAR("border_clear"),
    BORDER_COLOR("border_color"),
    BORDER_HORIZONTAL("border_horizontal"),
    BORDER_INNER("border_inner"),
    BORDER_LEFT("border_left"),
    BORDER_OUTER("border_outer"),
    BORDER_RIGHT("border_right"),
    BORDER_STYLE("border_style"),
    BORDER_TOP("border_top"),
    BORDER_VERTICAL("border_vertical"),
    FORMAT_ALIGN_CENTER("format_align_center"),
    FORMAT_ALIGN_JUSTIFY("format_align_justify"),
    FORMAT_ALIGN_LEFT("format_align_left"),
    FORMAT_ALIGN_RIGHT("format_align_right"),
    FORMAT_BOLD("format_bold"),
    FORMAT_CLEAR("format_clear"),
    FORMAT_COLOR_FILL("format_color_fill"),
    FORMAT_COLOR_RESET("format_color_reset"),
    FORMAT_COLOR_TEXT("format_color_text"),
    FORMAT_INDENT_DECREASE("format_indent_decrease"),
    FORMAT_INDENT_INCREASE("format_indent_increase"),
    FORMAT_ITALIC("format_italic"),
    FORMAT_LINE_SPACING("format_line_spacing"),
    FORMAT_LIST_BULLETED("format_list_bulleted"),
    FORMAT_LIST_NUMBERED("format_list_numbered"),
    FORMAT_PAINT("format_paint"),
    FORMAT_QUOTE("format_quote"),
    FORMAT_SIZE("format_size"),
    FORMAT_STRIKETHROUGH("format_strikethrough"),
    FORMAT_TEXTDIRECTION_L_TO_R("format_textdirection_l_to_r"),
    FORMAT_TEXTDIRECTION_R_TO_L("format_textdirection_r_to_l"),
    FORMAT_UNDERLINE("format_underline"),
    FUNCTIONS("functions"),
    INSERT_CHART("insert_chart"),
    INSERT_COMMENT("insert_comment"),
    INSERT_DRIVE_FILE("insert_drive_file"),
    INSERT_EMOTICON("insert_emoticon"),
    INSERT_INVITATION("insert_invitation"),
    INSERT_LINK("insert_link"),
    INSERT_PHOTO("insert_photo"),
    MERGE_TYPE("merge_type"),
    MODE_COMMENT("mode_comment"),
    MODE_EDIT("mode_edit"),
    PUBLISH("publish"),
    VERTICAL_ALIGN_BOTTOM("vertical_align_bottom"),
    VERTICAL_ALIGN_CENTER("vertical_align_center"),
    VERTICAL_ALIGN_TOP("vertical_align_top"),
    WRAP_TEXT("wrap_text"),
    ATTACHMENT("attachment"),
    CLOUD_CIRCLE("cloud_circle"),
    CLOUD_DONE("cloud_done"),
    CLOUD_DOWNLOAD("cloud_download"),
    CLOUD_OFF("cloud_off"),
    CLOUD_QUEUE("cloud_queue"),
    CLOUD_UPLOAD("cloud_upload"),
    CLOUD("cloud"),
    FILE_DOWNLOAD("file_download"),
    FILE_UPLOAD("file_upload"),
    FOLDER_OPEN("folder_open"),
    FOLDER_SHARED("folder_shared"),
    FOLDER("folder"),
    ACCESS_ALARM("access_alarm"),
    ACCESS_ALARMS("access_alarms"),
    ACCESS_TIME("access_time"),
    ADD_ALARM("add_alarm"),
    AIRPLANEMODE_OFF("airplanemode_off"),
    AIRPLANEMODE_ON("airplanemode_on"),
    BATTERY_20("battery_20"),
    BATTERY_30("battery_30"),
    BATTERY_50("battery_50"),
    BATTERY_60("battery_60"),
    BATTERY_80("battery_80"),
    BATTERY_90("battery_90"),
    BATTERY_ALERT("battery_alert"),
    BATTERY_CHARGING_20("battery_charging_20"),
    BATTERY_CHARGING_30("battery_charging_30"),
    BATTERY_CHARGING_50("battery_charging_50"),
    BATTERY_CHARGING_60("battery_charging_60"),
    BATTERY_CHARGING_80("battery_charging_80"),
    BATTERY_CHARGING_90("battery_charging_90"),
    BATTERY_CHARGING_FULL("battery_charging_full"),
    BATTERY_FULL("battery_full"),
    BATTERY_STD("battery_std"),
    BATTERY_UNKNOWN("battery_unknown"),
    BLUETOOTH_CONNECTED("bluetooth_connected"),
    BLUETOOTH_DISABLED("bluetooth_disabled"),
    BLUETOOTH_SEARCHING("bluetooth_searching"),
    BLUETOOTH("bluetooth"),
    BRIGHTNESS_AUTO("brightness_auto"),
    BRIGHTNESS_HIGH("brightness_high"),
    BRIGHTNESS_LOW("brightness_low"),
    BRIGHTNESS_MEDIUM("brightness_medium"),
    DATA_USAGE("data_usage"),
    DEVELOPER_MODE("developer_mode"),
    DEVICES("devices"),
    DVR("dvr"),
    GPS_FIXED("gps_fixed"),
    GPS_NOT_FIXED("gps_not_fixed"),
    GPS_OFF("gps_off"),
    LOCATION_DISABLED("location_disabled"),
    LOCATION_SEARCHING("location_searching"),
    MULTITRACK_AUDIO("multitrack_audio"),
    NETWORK_CELL("network_cell"),
    NETWORK_WIFI("network_wifi"),
    NFC("nfc"),
    NOW_WALLPAPER("now_wallpaper"),
    NOW_WIDGETS("now_widgets"),
    SCREEN_LOCK_LANDSCAPE("screen_lock_landscape"),
    SCREEN_LOCK_PORTRAIT("screen_lock_portrait"),
    SCREEN_LOCK_ROTATION("screen_lock_rotation"),
    SCREEN_ROTATION("screen_rotation"),
    SD_STORAGE("sd_storage"),
    SETTINGS_SYSTEM_DAYDREAM("settings_system_daydream"),
    SIGNAL_CELLULAR_0_BAR("signal_cellular_0_bar"),
    SIGNAL_CELLULAR_1_BAR("signal_cellular_1_bar"),
    SIGNAL_CELLULAR_2_BAR("signal_cellular_2_bar"),
    SIGNAL_CELLULAR_3_BAR("signal_cellular_3_bar"),
    SIGNAL_CELLULAR_4_BAR("signal_cellular_4_bar"),
    WIFI_STATUSBAR_CONNECTED_NO_INTERNET_AFTER("wifi_statusbar_connected_no_internet_after"),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR("signal_cellular_connected_no_internet_0_bar"),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR("signal_cellular_connected_no_internet_1_bar"),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR("signal_cellular_connected_no_internet_2_bar"),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR("signal_cellular_connected_no_internet_3_bar"),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("signal_cellular_connected_no_internet_4_bar"),
    SIGNAL_CELLULAR_NO_SIM("signal_cellular_no_sim"),
    SIGNAL_CELLULAR_NULL("signal_cellular_null"),
    SIGNAL_CELLULAR_OFF("signal_cellular_off"),
    SIGNAL_WIFI_0_BAR("signal_wifi_0_bar"),
    SIGNAL_WIFI_1_BAR("signal_wifi_1_bar"),
    SIGNAL_WIFI_2_BAR("signal_wifi_2_bar"),
    SIGNAL_WIFI_3_BAR("signal_wifi_3_bar"),
    SIGNAL_WIFI_4_BAR("signal_wifi_4_bar"),
    SIGNAL_WIFI_OFF("signal_wifi_off"),
    SIGNAL_WIFI_STATUSBAR_1_BAR("signal_wifi_statusbar_1_bar"),
    SIGNAL_WIFI_STATUSBAR_2_BAR("signal_wifi_statusbar_2_bar"),
    SIGNAL_WIFI_STATUSBAR_3_BAR("signal_wifi_statusbar_3_bar"),
    SIGNAL_WIFI_STATUSBAR_4_BAR("signal_wifi_statusbar_4_bar"),
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_("signal_wifi_statusbar_connected_no_internet_"),
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET("signal_wifi_statusbar_connected_no_internet"),
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_2("signal_wifi_statusbar_connected_no_internet_2"),
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_3("signal_wifi_statusbar_connected_no_internet_3"),
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4("signal_wifi_statusbar_connected_no_internet_4"),
    WIFI_STATUSBAR_NOT_CONNECTED_AFTER("wifi_statusbar_not_connected_after"),
    SIGNAL_WIFI_STATUSBAR_NOT_CONNECTED("signal_wifi_statusbar_not_connected"),
    SIGNAL_WIFI_STATUSBAR_NULL("signal_wifi_statusbar_null"),
    STORAGE("storage"),
    USB("usb"),
    WIFI_LOCK("wifi_lock"),
    WIFI_TETHERING("wifi_tethering"),
    CAST_CONNECTED("cast_connected"),
    CAST("cast"),
    COMPUTER("computer"),
    DESKTOP_MAC("desktop_mac"),
    DESKTOP_WINDOWS("desktop_windows"),
    DOCK("dock"),
    GAMEPAD("gamepad"),
    HEADSET_MIC("headset_mic"),
    HEADSET("headset"),
    KEYBOARD_ALT("keyboard_alt"),
    KEYBOARD_ARROW_DOWN("keyboard_arrow_down"),
    KEYBOARD_ARROW_LEFT("keyboard_arrow_left"),
    KEYBOARD_ARROW_RIGHT("keyboard_arrow_right"),
    KEYBOARD_ARROW_UP("keyboard_arrow_up"),
    KEYBOARD_BACKSPACE("keyboard_backspace"),
    KEYBOARD_CAPSLOCK("keyboard_capslock"),
    KEYBOARD_CONTROL("keyboard_control"),
    KEYBOARD_HIDE("keyboard_hide"),
    KEYBOARD_RETURN("keyboard_return"),
    KEYBOARD_TAB("keyboard_tab"),
    KEYBOARD_VOICE("keyboard_voice"),
    KEYBOARD("keyboard"),
    LAPTOP_CHROMEBOOK("laptop_chromebook"),
    LAPTOP_MAC("laptop_mac"),
    LAPTOP_WINDOWS("laptop_windows"),
    LAPTOP("laptop"),
    MEMORY("memory"),
    MOUSE("mouse"),
    PHONE_ANDROID("phone_android"),
    PHONE_IPHONE("phone_iphone"),
    PHONELINK_OFF("phonelink_off"),
    PHONELINK("phonelink"),
    SECURITY("security"),
    SIM_CARD("sim_card"),
    SMARTPHONE("smartphone"),
    SPEAKER("speaker"),
    TABLET_ANDROID("tablet_android"),
    TABLET_MAC("tablet_mac"),
    TABLET("tablet"),
    TV("tv"),
    WATCH("watch"),
    ADD_TO_PHOTOS("add_to_photos"),
    ADJUST("adjust"),
    ASSISTANT_PHOTO("assistant_photo"),
    AUDIOTRACK("audiotrack"),
    BLUR_CIRCULAR("blur_circular"),
    BLUR_LINEAR("blur_linear"),
    BLUR_OFF("blur_off"),
    BLUR_ON("blur_on"),
    BRIGHTNESS_1("brightness_1"),
    BRIGHTNESS_2("brightness_2"),
    BRIGHTNESS_3("brightness_3"),
    BRIGHTNESS_4("brightness_4"),
    BRIGHTNESS_5("brightness_5"),
    BRIGHTNESS_6("brightness_6"),
    BRIGHTNESS_7("brightness_7"),
    BRUSH("brush"),
    CAMERA_ALT("camera_alt"),
    CAMERA_FRONT("camera_front"),
    CAMERA_REAR("camera_rear"),
    CAMERA_ROLL("camera_roll"),
    CAMERA("camera"),
    CENTER_FOCUS_STRONG("center_focus_strong"),
    CENTER_FOCUS_WEAK("center_focus_weak"),
    COLLECTIONS("collections"),
    COLOR_LENS("color_lens"),
    COLORIZE("colorize"),
    COMPARE("compare"),
    CONTROL_POINT_DUPLICATE("control_point_duplicate"),
    CONTROL_POINT("control_point"),
    CROP_3_2("crop_3_2"),
    CROP_5_4("crop_5_4"),
    CROP_7_5("crop_7_5"),
    CROP_16_9("crop_16_9"),
    CROP_DIN("crop_din"),
    CROP_FREE("crop_free"),
    CROP_LANDSCAPE("crop_landscape"),
    CROP_ORIGINAL("crop_original"),
    CROP_PORTRAIT("crop_portrait"),
    CROP_SQUARE("crop_square"),
    CROP("crop"),
    DEHAZE("dehaze"),
    DETAILS("details"),
    EDIT("edit"),
    EXPOSURE_MINUS_1("exposure_minus_1"),
    EXPOSURE_MINUS_2("exposure_minus_2"),
    EXPOSURE_PLUS_1("exposure_plus_1"),
    EXPOSURE_PLUS_2("exposure_plus_2"),
    EXPOSURE_ZERO("exposure_zero"),
    EXPOSURE("exposure"),
    FILTER_1("filter_1"),
    FILTER_2("filter_2"),
    FILTER_3("filter_3"),
    FILTER_4("filter_4"),
    FILTER_5("filter_5"),
    FILTER_6("filter_6"),
    FILTER_7("filter_7"),
    FILTER_8("filter_8"),
    FILTER_9_PLUS("filter_9_plus"),
    FILTER_9("filter_9"),
    FILTER_B_AND_W("filter_b_and_w"),
    FILTER_CENTER_FOCUS("filter_center_focus"),
    FILTER_DRAMA("filter_drama"),
    FILTER_FRAMES("filter_frames"),
    FILTER_HDR("filter_hdr"),
    FILTER_NONE("filter_none"),
    FILTER_TILT_SHIFT("filter_tilt_shift"),
    FILTER_VINTAGE("filter_vintage"),
    FILTER("filter"),
    FLARE("flare"),
    FLASH_AUTO("flash_auto"),
    FLASH_OFF("flash_off"),
    FLASH_ON("flash_on"),
    FLIP("flip"),
    GRADIENT("gradient"),
    GRAIN("grain"),
    GRID_OFF("grid_off"),
    GRID_ON("grid_on"),
    HDR_OFF("hdr_off"),
    HDR_ON("hdr_on"),
    HDR_STRONG("hdr_strong"),
    HDR_WEAK("hdr_weak"),
    HEALING("healing"),
    IMAGE_ASPECT_RATIO("image_aspect_ratio"),
    IMAGE("image"),
    ISO("iso"),
    LANDSCAPE("landscape"),
    LEAK_ADD("leak_add"),
    LEAK_REMOVE("leak_remove"),
    LENS("lens"),
    LOOKS_3("looks_3"),
    LOOKS_4("looks_4"),
    LOOKS_5("looks_5"),
    LOOKS_6("looks_6"),
    LOOKS_ONE("looks_one"),
    LOOKS_TWO("looks_two"),
    LOOKS("looks"),
    LOUPE("loupe"),
    MOVIE_CREATION("movie_creation"),
    NATURE_PEOPLE("nature_people"),
    NATURE("nature"),
    NAVIGATE_BEFORE("navigate_before"),
    NAVIGATE_NEXT("navigate_next"),
    PALETTE("palette"),
    PANORAMA_FISHEYE("panorama_fisheye"),
    PANORAMA_HORIZONTAL("panorama_horizontal"),
    PANORAMA_VERTICAL("panorama_vertical"),
    PANORAMA_WIDE_ANGLE("panorama_wide_angle"),
    PANORAMA("panorama"),
    PHOTO_ALBUM("photo_album"),
    PHOTO_CAMERA("photo_camera"),
    PHOTO_LIBRARY("photo_library"),
    PHOTO("photo"),
    PORTRAIT("portrait"),
    REMOVE_RED_EYE("remove_red_eye"),
    ROTATE_LEFT("rotate_left"),
    ROTATE_RIGHT("rotate_right"),
    SLIDESHOW("slideshow"),
    STRAIGHTEN("straighten"),
    STYLE("style"),
    SWITCH_CAMERA("switch_camera"),
    SWITCH_VIDEO("switch_video"),
    TAG_FACES("tag_faces"),
    TEXTURE("texture"),
    TIMELAPSE("timelapse"),
    TIMER_3("timer_3"),
    TIMER_10("timer_10"),
    TIMER_AUTO("timer_auto"),
    TIMER_OFF("timer_off"),
    TIMER("timer"),
    TONALITY("tonality"),
    TRANSFORM("transform"),
    TUNE("tune"),
    WB_AUTO("wb_auto"),
    WB_CLOUDY("wb_cloudy"),
    WB_INCANDESCENT("wb_incandescent"),
    WB_IRRADESCENT("wb_irradescent"),
    WB_SUNNY("wb_sunny"),
    BEENHERE("beenhere"),
    DIRECTIONS_BIKE("directions_bike"),
    DIRECTIONS_BUS("directions_bus"),
    DIRECTIONS_CAR("directions_car"),
    DIRECTIONS_FERRY("directions_ferry"),
    DIRECTIONS_SUBWAY("directions_subway"),
    DIRECTIONS_TRAIN("directions_train"),
    DIRECTIONS_TRANSIT("directions_transit"),
    DIRECTIONS_WALK("directions_walk"),
    DIRECTIONS("directions"),
    FLIGHT("flight"),
    HOTEL("hotel"),
    LAYERS_CLEAR("layers_clear"),
    LAYERS("layers"),
    LOCAL_AIRPORT("local_airport"),
    LOCAL_ATM("local_atm"),
    LOCAL_ATTRACTION("local_attraction"),
    LOCAL_BAR("local_bar"),
    LOCAL_CAFE("local_cafe"),
    LOCAL_CAR_WASH("local_car_wash"),
    LOCAL_CONVENIENCE_STORE("local_convenience_store"),
    LOCAL_DRINK("local_drink"),
    LOCAL_FLORIST("local_florist"),
    LOCAL_GAS_STATION("local_gas_station"),
    LOCAL_GROCERY_STORE("local_grocery_store"),
    LOCAL_HOSPITAL("local_hospital"),
    LOCAL_HOTEL("local_hotel"),
    LOCAL_LAUNDRY_SERVICE("local_laundry_service"),
    LOCAL_LIBRARY("local_library"),
    LOCAL_MALL("local_mall"),
    LOCAL_MOVIES("local_movies"),
    LOCAL_OFFER("local_offer"),
    LOCAL_PARKING("local_parking"),
    LOCAL_PHARMACY("local_pharmacy"),
    LOCAL_PHONE("local_phone"),
    LOCAL_PIZZA("local_pizza"),
    LOCAL_PLAY("local_play"),
    LOCAL_POST_OFFICE("local_post_office"),
    LOCAL_PRINT_SHOP("local_print_shop"),
    LOCAL_RESTAURANT("local_restaurant"),
    LOCAL_SEE("local_see"),
    LOCAL_SHIPPING("local_shipping"),
    LOCAL_TAXI("local_taxi"),
    LOCATION_HISTORY("location_history"),
    MAP("map"),
    MY_LOCATION("my_location"),
    NAVIGATION("navigation"),
    PIN_DROP("pin_drop"),
    PLACE("place"),
    RATE_REVIEW("rate_review"),
    RESTAURANT_MENU("restaurant_menu"),
    SATELLITE("satellite"),
    STORE_MALL_DIRECTORY("store_mall_directory"),
    TERRAIN("terrain"),
    TRAFFIC("traffic"),
    APPS("apps"),
    ARROW_BACK("arrow_back"),
    ARROW_DROP_DOWN_CIRCLE("arrow_drop_down_circle"),
    ARROW_DROP_DOWN("arrow_drop_down"),
    ARROW_DROP_UP("arrow_drop_up"),
    ARROW_FORWARD("arrow_forward"),
    CANCEL("cancel"),
    CHECK("check"),
    CHEVRON_LEFT("chevron_left"),
    CHEVRON_RIGHT("chevron_right"),
    CLOSE("close"),
    EXPAND_LESS("expand_less"),
    EXPAND_MORE("expand_more"),
    FULLSCREEN_EXIT("fullscreen_exit"),
    FULLSCREEN("fullscreen"),
    MENU("menu"),
    MORE_HORIZ("more_horiz"),
    MORE_VERT("more_vert"),
    REFRESH("refresh"),
    UNFOLD_LESS("unfold_less"),
    UNFOLD_MORE("unfold_more"),
    ADB("adb"),
    BLUETOOTH_AUDIO("bluetooth_audio"),
    DISC_FULL("disc_full"),
    DND_FORWARDSLASH("dnd_forwardslash"),
    DO_NOT_DISTURB("do_not_disturb"),
    DRIVE_ETA("drive_eta"),
    EVENT_AVAILABLE("event_available"),
    EVENT_BUSY("event_busy"),
    EVENT_NOTE("event_note"),
    FOLDER_SPECIAL("folder_special"),
    MMS("mms"),
    MORE("more"),
    NETWORK_LOCKED("network_locked"),
    PHONE_BLUETOOTH_SPEAKER("phone_bluetooth_speaker"),
    PHONE_FORWARDED("phone_forwarded"),
    PHONE_IN_TALK("phone_in_talk"),
    PHONE_LOCKED("phone_locked"),
    PHONE_MISSED("phone_missed"),
    PHONE_PAUSED("phone_paused"),
    PLAY_DOWNLOAD("play_download"),
    PLAY_INSTALL("play_install"),
    SD_CARD("sd_card"),
    SIM_CARD_ALERT("sim_card_alert"),
    SMS_FAILED("sms_failed"),
    SMS("sms"),
    SYNC_DISABLED("sync_disabled"),
    SYNC_PROBLEM("sync_problem"),
    SYNC("sync"),
    SYSTEM_UPDATE("system_update"),
    TAP_AND_PLAY("tap_and_play"),
    TIME_TO_LEAVE("time_to_leave"),
    VIBRATION("vibration"),
    VOICE_CHAT("voice_chat"),
    VPN_LOCK("vpn_lock"),
    CAKE("cake"),
    DOMAIN("domain"),
    GROUP_ADD("group_add"),
    GROUP("group"),
    LOCATION_CITY("location_city"),
    MOOD("mood"),
    NOTIFICATIONS_NONE("notifications_none"),
    NOTIFICATIONS_OFF("notifications_off"),
    NOTIFICATIONS_ON("notifications_on"),
    NOTIFICATIONS_PAUSED("notifications_paused"),
    NOTIFICATIONS("notifications"),
    PAGES("pages"),
    PARTY_MODE("party_mode"),
    PEOPLE_OUTLINE("people_outline"),
    PEOPLE("people"),
    PERSON_ADD("person_add"),
    PERSON_OUTLINE("person_outline"),
    PERSON("person"),
    PLUS_ONE("plus_one"),
    POLL("poll"),
    PUBLIC("public"),
    SCHOOL("school"),
    SHARE("share"),
    WHATSHOT("whatshot"),
    CHECK_BOX_OUTLINE_BLANK("check_box_outline_blank"),
    CHECK_BOX("check_box"),
    RADIO_BUTTON_OFF("radio_button_off"),
    RADIO_BUTTON_ON("radio_button_on"),
    STAR_HALF("star_half"),
    STAR_OUTLINE("star_outline"),
    STAR("star"),
    ACCESSIBLE("accessible"),
    ALL_OUT("all_out"),
    CODE("code"),
    COMPARE_ARROWS("compare_arrows"),
    COPYRIGHT("copyright"),
    DATE_RANGE("date_range"),
    DONUT_LARGE("donut_large"),
    DONUT_SMALL("donut_small"),
    FINGERPRINT("fingerprint"),
    GAVEL("gavel"),
    IMPORTANT_DEVICES("important_devices"),
    LIGHTBULB_OUTLINE("lightbulb_outline"),
    LINE_STYLE("line_style"),
    LINE_WEIGHT("line_weight"),
    MOTORCYCLE("motorcycle"),
    OPACITY("opacity"),
    PAN_TOOL("pan_tool"),
    PETS("pets"),
    PICTURE_IN_PICTURE_ALT("picture_in_picture_alt"),
    PREGNANT_WOMAN("pregnant_woman"),
    RECORD_VOICE_OVER("record_voice_over"),
    ROUNDED_CORNER("rounded_corner"),
    ROWING("rowing"),
    TIMELINE("timeline"),
    TOUCH_APP("touch_app"),
    UPDATE("update"),
    WATCH_LATER("watch_later"),
    ADD_TO_QUEUE("add_to_queue"),
    ART_TRACK("art_track"),
    FIBER_DVR("fiber_dvr"),
    FIBER_MANUAL_RECORD("fiber_manual_record"),
    FIBER_NEW("fiber_new"),
    FIBER_PIN("fiber_pin"),
    FIBER_SMART_RECORD("fiber_smart_record"),
    MUSIC_VIDEO("music_video"),
    PLAYLIST_ADD_CHECK("playlist_add_check"),
    PLAYLIST_PLAY("playlist_play"),
    QUEUE_PLAY_NEXT("queue_play_next"),
    REMOVE_FROM_QUEUE("remove_from_queue"),
    SLOW_MOTION_VIDEO("slow_motion_video"),
    SUBSCRIPTIONS("subscriptions"),
    WEB_ASSET("web_asset"),
    CALL_MISSED_OUTGOING("call_missed_outgoing"),
    CONTACT_MAIL("contact_mail"),
    IMPORT_CONTACTS("import_contacts"),
    MAIL_OUTLINE("mail_outline"),
    SCREEN_SHARE("screen_share"),
    STOP_SCREEN_SHARE("stop_screen_share"),
    MOVE_TO_INBOX("move_to_inbox"),
    NEXT_WEEK("next_week"),
    UNARCHIVE("unarchive"),
    WEEKEND("weekend"),
    DRAG_HANDLE("drag_handle"),
    FORMAT_SHAPES("format_shapes"),
    HIGHLIGHT("highlight"),
    LINEAR_SCALE("linear_scale"),
    SHORT_TEXT("short_text"),
    TEXT_FIELDS("text_fields"),
    CREATE_NEW_FOLDER("create_new_folder"),
    DEVICES_OTHER("devices_other"),
    VIDEOGAME_ASSET("videogame_asset"),
    ADD_A_PHOTO("add_a_photo"),
    CROP_ROTATE("crop_rotate"),
    LINKED_CAMERA("linked_camera"),
    MOVIE_FILTER("movie_filter"),
    PHOTO_FILTER("photo_filter"),
    ADD_LOCATION("add_location"),
    EDIT_LOCATION("edit_location"),
    NEAR_ME("near_me"),
    PERSON_PIN_CIRCLE("person_pin_circle"),
    ZOOM_OUT_MAP("zoom_out_map"),
    ARROW_DOWNWARD("arrow_downward"),
    ARROW_UPWARD("arrow_upward"),
    SUBDIRECTORY_ARROW_LEFT("subdirectory_arrow_left"),
    SUBDIRECTORY_ARROW_RIGHT("subdirectory_arrow_right"),
    ENHANCED_ENCRYPTION("enhanced_encryption"),
    NETWORK_CHECK("network_check"),
    NO_ENCRYPTION("no_encryption"),
    AC_UNIT("ac_unit"),
    AIRPORT_SHUTTLE("airport_shuttle"),
    AIR_INCLUSIVE("air_inclusive"),
    BEACH_ACCESS("beach_access"),
    BUSINESS_CENTER("business_center"),
    CASINO("casino"),
    CHILD_CARE("child_care"),
    CHILD_FRIENDLY("child_friendly"),
    FITNESS_CENTER("fitness_center"),
    FREE_BREAKFAST("free_breakfast"),
    GOLF_COURSE("golf_course"),
    HOT_TUB("hot_tub"),
    KITCHEN("kitchen"),
    POOL("pool"),
    ROOM_SERVICE("room_service"),
    RV_HOOKUP("rv_hookup"),
    SMOKE_FREE("smoke_free"),
    SMOKING_ROOMS("smoking_rooms"),
    VIDEO_LIBRARY("video_library"),
    SPA("spa"),
    SORT_BY_ALPHA("sort_by_alpha"),
    PICTURE_AS_PDF("picture_as_pdf"),;
    
    private final String cssClass;

    IconType(final String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    public String getCssName() {
        return cssClass;
    }

    public static IconType fromStyleName(final String styleName) {
        return EnumHelper.fromStyleName(styleName, IconType.class, DEFAULT);
    }
}
