/*
 * #%L
 * GwtMaterial
 * %%
 * Copyright (C) 2015 - 2017 GwtMaterialDesign
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package gwt.material.design.client.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

public class PageSelectionEvent extends GwtEvent<PageSelectionEvent.PageSelectionHandler> {

    private int pageFrom;
    private int pageTo;
    private int totalPage;

    public interface PageSelectionHandler extends EventHandler {
        void onPageSelected(PageSelectionEvent event);
    }

    public static final Type<PageSelectionHandler> TYPE = new Type<>();

    @Override
    public Type<PageSelectionHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(PageSelectionHandler handler) {
        handler.onPageSelected(this);
    }

    public int getPageFrom() {
        return pageFrom;
    }

    public void setPageFrom(int pageFrom) {
        this.pageFrom = pageFrom;
    }

    public int getPageTo() {
        return pageTo;
    }

    public void setPageTo(int pageTo) {
        this.pageTo = pageTo;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
}
