/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.google;

import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Objects;

public class GoogleToken
extends OAuth2AccessToken {
    private static final long serialVersionUID = 7845679917727899612L;
    private final String openIdToken;

    public GoogleToken(String accessToken, String openIdToken, String rawResponse) {
        this(accessToken, null, null, null, null, openIdToken, rawResponse);
    }

    public GoogleToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String openIdToken, String rawResponse) {
        super(accessToken, tokenType, expiresIn, refreshToken, scope, rawResponse);
        this.openIdToken = openIdToken;
    }

    public String getOpenIdToken() {
        return this.openIdToken;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Objects.hashCode(this.openIdToken);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.openIdToken, ((GoogleToken)((Object)obj)).getOpenIdToken());
    }

    public String toString() {
        return "GoogleToken{access_token=" + this.getAccessToken() + ", token_type=" + this.getTokenType() + ", expires_in=" + this.getExpiresIn() + ", refresh_token=" + this.getRefreshToken() + ", scope=" + this.getScope() + ", open_id_token=" + this.openIdToken + '}';
    }
}

