/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css.ast;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSubstitution;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CssSprite
extends CssRule
implements CssSubstitution {
    public static final String IMAGE_PROPERTY_NAME = "gwt-image";
    private CssProperty.DotPathValue resourceFunction;

    @Override
    public List<CssProperty> getProperties() {
        return new SpritePropertyList(super.getProperties());
    }

    public CssProperty.DotPathValue getResourceFunction() {
        return this.resourceFunction;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    public void setResourceFunction(CssProperty.DotPathValue resourceFunction) {
        this.resourceFunction = resourceFunction;
    }

    @Override
    public void traverse(CssVisitor visitor, Context context) {
        if (visitor.visit(this, context)) {
            visitor.acceptWithInsertRemove(this.selectors);
            visitor.acceptWithInsertRemove(this.getProperties());
        }
        visitor.endVisit(this, context);
    }

    private boolean processProperty(CssProperty property) {
        if (IMAGE_PROPERTY_NAME.equals(property.getName())) {
            this.setImageProperty(property.getValues());
            return true;
        }
        return false;
    }

    private void setImageProperty(CssProperty.Value value) {
        CssProperty.StringValue stringValue = value.isStringValue();
        if (stringValue != null) {
            String s = stringValue.getValue();
            if (s.startsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            this.resourceFunction = new CssProperty.DotPathValue(s);
        } else {
            CssProperty.ListValue listValue = value.isListValue();
            if (listValue != null) {
                List<CssProperty.Value> values = listValue.getValues();
                if (values.size() == 1) {
                    this.setImageProperty(values.get(0));
                }
            } else {
                throw new IllegalArgumentException("The gwt-image property of @sprite must have exactly one value");
            }
        }
    }

    private class SpritePropertyList
    implements List<CssProperty> {
        private final List<CssProperty> source;

        public SpritePropertyList(List<CssProperty> source) {
            this.source = source;
        }

        @Override
        public boolean add(CssProperty o) {
            if (!CssSprite.this.processProperty(o)) {
                return this.source.add(o);
            }
            return false;
        }

        @Override
        public void add(int index, CssProperty element) {
            if (!CssSprite.this.processProperty(element)) {
                this.source.add(index, element);
            }
        }

        @Override
        public boolean addAll(Collection<? extends CssProperty> c) {
            return this.source.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends CssProperty> c) {
            return this.source.addAll(index, c);
        }

        @Override
        public void clear() {
            this.source.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.source.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.source.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.source).equals(o);
        }

        @Override
        public CssProperty get(int index) {
            return this.source.get(index);
        }

        @Override
        public int hashCode() {
            return ((Object)this.source).hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.source.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public Iterator<CssProperty> iterator() {
            return this.source.iterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.source.lastIndexOf(o);
        }

        @Override
        public ListIterator<CssProperty> listIterator() {
            return this.source.listIterator();
        }

        @Override
        public ListIterator<CssProperty> listIterator(int index) {
            return this.source.listIterator(index);
        }

        @Override
        public CssProperty remove(int index) {
            return this.source.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            return this.source.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.source.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.source.retainAll(c);
        }

        @Override
        public CssProperty set(int index, CssProperty element) {
            if (!CssSprite.this.processProperty(element)) {
                return this.source.set(index, element);
            }
            return this.source.remove(index);
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public List<CssProperty> subList(int fromIndex, int toIndex) {
            return this.source.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.source.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.source.toArray(a);
        }
    }
}

