/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client.impl;

import com.google.gwt.core.shared.GwtIncompatible;
import com.google.gwt.core.shared.SerializableThrowable;
import com.google.gwt.junit.client.TimeoutException;
import java.io.Serializable;
import junit.framework.AssertionFailedError;

public class JUnitResult
implements Serializable {
    SerializableThrowable thrown;
    private transient String agent;
    private transient String host;

    public String getAgent() {
        return this.agent;
    }

    public SerializableThrowable getException() {
        return this.thrown;
    }

    public boolean isAnyException() {
        return this.thrown != null;
    }

    @GwtIncompatible
    public boolean isExceptionOf(Class<?> expectedException) {
        try {
            return this.thrown == null ? false : expectedException.isAssignableFrom(Class.forName(this.thrown.getDesignatedType()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public void setException(Throwable exception) {
        this.thrown = SerializableThrowable.fromThrowable(exception);
        if (!this.thrown.isExactDesignatedTypeKnown()) {
            JUnitResult.improveDesignatedType(this.thrown, exception);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String toString() {
        return "TestResult {thrown: " + this.thrown + ", agent: " + this.agent + ", host: " + this.host + "}";
    }

    private static void improveDesignatedType(SerializableThrowable t, Throwable designatedType) {
        if (designatedType instanceof AssertionFailedError) {
            String className = "junit.framework.AssertionFailedError";
            t.setDesignatedType(className, AssertionFailedError.class == designatedType.getClass());
        } else if (designatedType instanceof TimeoutException) {
            String className = "com.google.gwt.junit.client.TimeoutException";
            t.setDesignatedType(className, TimeoutException.class == designatedType.getClass());
        }
    }
}

